/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.util;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockUtils {
    public static ForgeDirection get2dOrientation(EntityLiving entity) {
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (l) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.SOUTH;
    }

    public static ForgeDirection get3dOrientation(EntityLiving entity) {
        if (entity.field_70125_A > 66.5f) {
            return ForgeDirection.DOWN;
        }
        if (entity.field_70125_A < -66.5f) {
            return ForgeDirection.UP;
        }
        return BlockUtils.get2dOrientation(entity);
    }

    public static void dropItemStackInWorld(World worldObj, int x, int y, int z, ItemStack stack) {
        float f = 0.7f;
        double d0 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d1 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(worldObj, (double)x + d0, (double)y + d1, (double)z + d2, stack);
        entityitem.field_70293_c = 10;
        if (stack.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        worldObj.func_72838_d((Entity)entityitem);
    }

    public static void dropInventoryItems(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            Random rand = tileEntity.field_70331_k.field_73012_v;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack == null) continue;
                BlockUtils.dropItemStackInWorld(tileEntity.field_70331_k, tileEntity.field_70329_l, tileEntity.field_70330_m, tileEntity.field_70327_n, itemStack);
            }
        }
    }
}

