/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.drawable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import openperipheral.api.IDrawable;
import openperipheral.common.drawable.BaseDrawable;
import openperipheral.common.tileentity.TileEntityGlassesBridge;
import openperipheral.common.util.ByteUtils;
import openperipheral.common.util.FontSizeChecker;
import org.lwjgl.opengl.GL11;

public class DrawableText
extends BaseDrawable
implements IDrawable {
    private short x;
    private short y;
    private String text;
    private int color;
    private float scale = 1.0f;
    public static final int X_CHANGED = 1;
    public static final int Y_CHANGED = 2;
    public static final int TEXT_CHANGED = 3;
    public static final int COLOR_CHANGED = 4;
    public static final int Z_CHANGED = 5;
    public static final int SCALE_CHANGED = 6;

    public DrawableText() {
    }

    public DrawableText(TileEntityGlassesBridge parent, int x, int y, String text, int color) {
        super(parent);
        this.x = (short)x;
        this.y = (short)y;
        this.text = text;
        this.color = color;
        this.methodNames = new String[]{"setX", "getX", "setY", "getY", "setColor", "getColor", "setText", "getText", "setZIndex", "getZIndex", "setScale", "getScale", "getWidth", "delete"};
    }

    @Override
    public void draw(float partialTicks) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GL11.glPushMatrix();
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        fontRenderer.func_78276_b(this.text, 0, 0, this.color);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public int getColor() {
        return this.color;
    }

    public float getScale() {
        return this.scale;
    }

    public String getText() {
        return this.text;
    }

    public int getWidth() {
        return FontSizeChecker.getInstance().getStringWidth(this.getText());
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZIndex() {
        return this.zIndex;
    }

    @Override
    public void readFrom(DataInputStream stream, Short changeMask) {
        try {
            if (ByteUtils.get(changeMask, 1)) {
                this.x = stream.readShort();
            }
            if (ByteUtils.get(changeMask, 2)) {
                this.y = stream.readShort();
            }
            if (ByteUtils.get(changeMask, 3)) {
                this.text = stream.readUTF();
            }
            if (ByteUtils.get(changeMask, 4)) {
                this.color = stream.readInt();
            }
            if (ByteUtils.get(changeMask, 5)) {
                this.zIndex = stream.readByte();
            }
            if (ByteUtils.get(changeMask, 6)) {
                this.scale = stream.readFloat();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int setColor(int c) {
        if (this.color == c) {
            return -1;
        }
        this.color = c;
        return 4;
    }

    public int setScale(float s) {
        if (this.scale == s) {
            return -1;
        }
        this.scale = s;
        return 6;
    }

    public int setText(String t) {
        if (t.equals(this.text)) {
            return -1;
        }
        this.text = t;
        return 3;
    }

    public int setX(short _x) {
        if (this.x == _x) {
            return -1;
        }
        this.x = _x;
        return 1;
    }

    public int setY(short _y) {
        if (this.y == _y) {
            return -1;
        }
        this.y = _y;
        return 2;
    }

    @Override
    public int setZIndex(byte z) {
        if (this.zIndex == z) {
            return -1;
        }
        this.zIndex = z;
        return 5;
    }

    @Override
    public void writeTo(DataOutputStream stream, Short changeMask) {
        try {
            if (ByteUtils.get(changeMask, 1)) {
                stream.writeShort(this.x);
            }
            if (ByteUtils.get(changeMask, 2)) {
                stream.writeShort(this.y);
            }
            if (ByteUtils.get(changeMask, 3)) {
                stream.writeUTF(this.text);
            }
            if (ByteUtils.get(changeMask, 4)) {
                stream.writeInt(this.color);
            }
            if (ByteUtils.get(changeMask, 5)) {
                stream.writeByte(this.zIndex);
            }
            if (ByteUtils.get(changeMask, 6)) {
                stream.writeFloat(this.scale);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

