/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.definition;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import openperipheral.api.IClassDefinition;
import openperipheral.api.IMethodDefinition;
import openperipheral.common.config.ConfigSettings;
import openperipheral.common.definition.DefinitionJsonMod;
import openperipheral.common.util.FileRetriever;

public class DefinitionManager {
    public static HashMap classList = new HashMap();

    public static void load() {
        JsonRootNode rootNode = DefinitionManager.loadJSON();
        if (rootNode != null) {
            for (JsonNode modNode : rootNode.getElements()) {
                DefinitionJsonMod definition = new DefinitionJsonMod(modNode);
                for (Map.Entry defs : definition.getValidClasses().entrySet()) {
                    DefinitionManager.addClass((Class)defs.getKey(), (IClassDefinition)defs.getValue());
                }
            }
        }
    }

    public static void addClassDefinition(IClassDefinition classDefinition) {
        if (classDefinition.getJavaClass() != null) {
            DefinitionManager.addClass(classDefinition.getJavaClass(), classDefinition);
        }
    }

    public static void addClass(Class klazz, IClassDefinition classDefinition) {
        if (classList.containsKey(klazz)) {
            ((ArrayList)classList.get(klazz)).add(classDefinition);
        } else {
            ArrayList<IClassDefinition> newlist = new ArrayList<IClassDefinition>();
            newlist.add(classDefinition);
            classList.put(klazz, newlist);
        }
    }

    public static ArrayList getMethodsForTile(TileEntity tile) {
        ArrayList<IMethodDefinition> methods = new ArrayList<IMethodDefinition>();
        for (Map.Entry entry : classList.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(tile.getClass())) continue;
            for (IClassDefinition def : (ArrayList)entry.getValue()) {
                ArrayList meths = def.getMethods(tile);
                for (IMethodDefinition methdef : meths) {
                    boolean dupe = false;
                    for (IMethodDefinition methdef2 : methods) {
                        if (!methdef2.getLuaName().equals(methdef.getLuaName())) continue;
                        dupe = true;
                    }
                    if (dupe) continue;
                    methods.add(methdef);
                }
            }
        }
        return methods;
    }

    private static JsonRootNode loadJSON() {
        FileRetriever.downloadFileIfOlderThan(ConfigSettings.DATA_URL, ConfigSettings.CACHE_PATH, ConfigSettings.FRESH_INSTALL ? 0 : ConfigSettings.CACHE_REFRESH_INTERVAL);
        try {
            BufferedReader br = new BufferedReader(new FileReader(ConfigSettings.CACHE_PATH));
            JdomParser parser = new JdomParser();
            JsonRootNode root = parser.parse((Reader)br);
            return root;
        }
        catch (Exception e) {
            System.out.println("Unable to parse openperipherals method data");
            return null;
        }
    }
}

