/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import openperipheral.common.tileentity.TileEntityGlassesBridge;
import openperipheral.common.util.MiscUtils;

public class TickHandler
implements ITickHandler {
    private static Map callbacks = Collections.synchronizedMap(new HashMap());

    public static Future addTickCallback(World world, Callable callback) throws InterruptedException {
        int worldId = world.field_73011_w.field_76574_g;
        if (!callbacks.containsKey(worldId)) {
            callbacks.put(worldId, new LinkedBlockingQueue());
        }
        FutureTask task = new FutureTask(callback);
        ((LinkedBlockingQueue)callbacks.get(worldId)).put(task);
        return task;
    }

    public String getLabel() {
        return "OpenPeripheral";
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.WORLD);
    }

    public void tickStart(EnumSet type, Object ... tickObjects) {
        if (type.contains(TickType.WORLD)) {
            int worldId;
            World world = (World)tickObjects[0];
            if (!world.field_72995_K) {
                for (EntityPlayer player : world.field_73010_i) {
                    TileEntityGlassesBridge bridge;
                    ItemStack helmet = player.field_71071_by.func_70440_f(3);
                    if (!MiscUtils.canBeGlasses(helmet) || (bridge = TileEntityGlassesBridge.getGlassesBridgeFromStack(player.field_70170_p, helmet)) == null) continue;
                    bridge.registerPlayer(player);
                }
            }
            if (callbacks.containsKey(worldId = world.field_73011_w.field_76574_g)) {
                LinkedBlockingQueue callbackList = (LinkedBlockingQueue)callbacks.get(worldId);
                FutureTask callback = (FutureTask)callbackList.poll();
                while (callback != null) {
                    callback.run();
                    callback = (FutureTask)callbackList.poll();
                }
            }
        }
    }
}

