/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openperipheral.OpenPeripheral;
import openperipheral.api.IAttachable;
import openperipheral.api.IMethodDefinition;
import openperipheral.api.IRestriction;
import openperipheral.common.converter.TypeConversionRegistry;
import openperipheral.common.core.TickHandler;
import openperipheral.common.definition.DefinitionManager;
import openperipheral.common.postchange.PostChangeRegistry;
import openperipheral.common.util.StringUtils;

public class HostedPeripheral
implements IHostedPeripheral {
    private static final MySecurityManager mySecurityManager = new MySecurityManager();
    private World worldObj;
    private Class klass;
    private int x;
    private int y;
    private int z;
    private String name;
    private ArrayList methods;
    private String[] methodNames;

    public HostedPeripheral(TileEntity tile) {
        this.klass = tile.getClass();
        this.worldObj = tile.field_70331_k;
        this.x = tile.field_70329_l;
        this.y = tile.field_70330_m;
        this.z = tile.field_70327_n;
        this.methods = DefinitionManager.getMethodsForTile(tile);
        ArrayList<String> mNames = new ArrayList<String>();
        mNames.add("listMethods");
        for (IMethodDefinition method : this.methods) {
            mNames.add(method.getLuaName());
        }
        this.methodNames = mNames.toArray(new String[mNames.size()]);
        Block blockType = tile.func_70311_o();
        ItemStack is = new ItemStack(blockType, 1, blockType.func_71873_h(tile.field_70331_k, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n));
        try {
            this.name = is.func_82833_r();
        }
        catch (Exception e) {
            try {
                this.name = is.func_77977_a();
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (this.name == null) {
            this.name = tile.getClass().getName();
        }
        this.name = this.name.replace(".", "_");
        this.name = this.name.replace(" ", "_");
        this.name = this.name.toLowerCase();
    }

    public String getType() {
        return this.name;
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public Object[] callMethod(IComputerAccess computer, int methodId, Object[] arguments) throws Exception {
        IMethodDefinition methodDefinition;
        if (methodId == 0) {
            return new Object[]{StringUtils.join(this.getMethodNames(), "\n")};
        }
        String callerClass = mySecurityManager.getCallerClassName(2);
        boolean isCableCall = callerClass.equals("dan200.computer.shared.TileEntityCable$RemotePeripheralWrapper") || callerClass.equals("openperipheral.common.tileentity.TileEntityProxy");
        if ((methodDefinition = (IMethodDefinition)this.methods.get(--methodId)) != null) {
            int i;
            if (!methodDefinition.needsSanitize()) {
                TileEntity tile = this.worldObj.func_72796_p(this.x, this.y, this.z);
                return this.executeMethod(isCableCall || methodDefinition.isInstant(), methodDefinition, tile, arguments);
            }
            ArrayList<Object> args = new ArrayList<Object>(Arrays.asList(arguments));
            Class[] requiredParameters = methodDefinition.getRequiredParameters();
            if (requiredParameters != null) {
                this.replaceArguments(args, methodDefinition.getReplacements());
                if (args.size() != requiredParameters.length) {
                    int replacements = 0;
                    if (methodDefinition.getReplacements() != null) {
                        replacements = methodDefinition.getReplacements().size();
                    }
                    throw new Exception("Invalid number of parameters. Expected " + (requiredParameters.length - replacements));
                }
                for (i = 0; i < requiredParameters.length; ++i) {
                    Object converted = TypeConversionRegistry.fromLua(args.get(i), requiredParameters[i]);
                    if (converted == null) {
                        throw new Exception("Invalid parameter number " + (i + 1));
                    }
                    args.set(i, converted);
                }
            }
            for (i = 0; i < args.size(); ++i) {
                ArrayList restrictions = methodDefinition.getRestrictions(i);
                if (restrictions == null) continue;
                for (IRestriction restriction : restrictions) {
                    if (restriction.isValid(args.get(i))) continue;
                    throw new Exception(restriction.getErrorMessage(i + 1));
                }
            }
            TileEntity tile = this.worldObj.func_72796_p(this.x, this.y, this.z);
            Object[] argsToUse = args.toArray(new Object[args.size()]);
            return this.executeMethod(isCableCall || methodDefinition.isInstant(), methodDefinition, tile, argsToUse);
        }
        return null;
    }

    private Object[] executeMethod(boolean isInstant, final IMethodDefinition methodDefinition, final TileEntity tile, final Object[] argsToUse) throws Exception {
        if (isInstant) {
            Object response = TypeConversionRegistry.toLua(methodDefinition.execute(tile, argsToUse));
            PostChangeRegistry.onPostChange(tile, methodDefinition, argsToUse);
            return new Object[]{response};
        }
        Future callback = TickHandler.addTickCallback(tile.field_70331_k, new Callable(){

            public Object call() throws Exception {
                Object response = TypeConversionRegistry.toLua(methodDefinition.execute(tile, argsToUse));
                PostChangeRegistry.onPostChange(tile, methodDefinition, argsToUse);
                return response;
            }
        });
        return new Object[]{callback.get()};
    }

    private void replaceArguments(ArrayList args, HashMap replacements) {
        if (replacements == null) {
            return;
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            String r = (String)replacement.getValue();
            Integer v = null;
            if (r.equals("x")) {
                v = this.x;
            } else if (r.equals("y")) {
                v = this.y;
            } else if (r.equals("z")) {
                v = this.z;
            } else if (r.equals("world")) {
                v = this.worldObj;
            }
            if (v == null) continue;
            args.add((Integer)replacement.getKey(), v);
        }
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(final IComputerAccess computer) {
        ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)OpenPeripheral.instance);
        try {
            computer.unmount("openp");
        }
        catch (Exception e) {
            // empty catch block
        }
        computer.mountFixedDir("openp", String.format("openperipheral/lua", container.getVersion()), true, 0L);
        try {
            TickHandler.addTickCallback(this.worldObj, new Callable(){

                public Object call() throws Exception {
                    TileEntity tile = HostedPeripheral.this.worldObj.func_72796_p(HostedPeripheral.this.x, HostedPeripheral.this.y, HostedPeripheral.this.z);
                    if (tile != null && tile instanceof IAttachable) {
                        ((IAttachable)tile).addComputer(computer);
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void detach(final IComputerAccess computer) {
        try {
            TickHandler.addTickCallback(this.worldObj, new Callable(){

                public Object call() throws Exception {
                    TileEntity tile = HostedPeripheral.this.worldObj.func_72796_p(HostedPeripheral.this.x, HostedPeripheral.this.y, HostedPeripheral.this.z);
                    if (tile != null && tile instanceof IAttachable) {
                        ((IAttachable)tile).removeComputer(computer);
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void update() {
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    static class MySecurityManager
    extends SecurityManager {
        MySecurityManager() {
        }

        public String getCallerClassName(int callStackDepth) {
            return this.getClassContext()[callStackDepth].getName();
        }
    }
}

