/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.client;

import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.NetLoginHandler;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet1Login;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.ForgeSubscribe;
import openperipheral.api.IDrawable;
import openperipheral.common.drawable.DrawableBox;
import openperipheral.common.drawable.DrawableText;
import openperipheral.common.util.ByteUtils;
import openperipheral.common.util.PacketChunker;

public class TerminalManager
implements IConnectionHandler {
    public static final byte CLEAR_ALL_FLAG = 0;
    public static final byte CHANGE_FLAG = 1;
    private HashMap drawables = new HashMap();
    private ArrayList drawableList = new ArrayList();
    private Comparator zIndexComparator = new Comparator(){

        public int compare(IDrawable s1, IDrawable s2) {
            return s1.getZIndex() - s2.getZIndex();
        }
    };

    public Collection getDrawables() {
        return this.drawableList;
    }

    public void handlePacket(Packet250CustomPayload packet) {
        try {
            byte[] bytes = PacketChunker.instance.getBytes(packet);
            if (bytes == null) {
                return;
            }
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(bytes));
            byte type = inputStream.readByte();
            if (type == 0) {
                this.drawables.clear();
                this.drawableList.clear();
                return;
            }
            int drawableCount = inputStream.readShort();
            for (int i = 0; i < drawableCount; ++i) {
                short changeMask = inputStream.readShort();
                short drawableId = inputStream.readShort();
                if (!ByteUtils.get(changeMask, 0)) {
                    this.drawables.remove(drawableId);
                    continue;
                }
                byte drawableType = inputStream.readByte();
                IDrawable drawable = null;
                if (this.drawables.containsKey(drawableId)) {
                    drawable = (IDrawable)this.drawables.get(drawableId);
                } else {
                    switch (drawableType) {
                        case 0: {
                            drawable = new DrawableText();
                            break;
                        }
                        default: {
                            drawable = new DrawableBox();
                        }
                    }
                }
                if (drawable == null) continue;
                drawable.readFrom(inputStream, changeMask);
                this.drawables.put(drawableId, drawable);
            }
            this.drawableList.clear();
            this.drawableList.addAll(this.drawables.values());
            Collections.sort(this.drawableList, this.zIndexComparator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ForgeSubscribe
    public void onRenderGameOverlay(RenderGameOverlayEvent evt) {
        if (evt.type == RenderGameOverlayEvent.ElementType.HELMET && evt instanceof RenderGameOverlayEvent.Post) {
            for (IDrawable drawable : this.drawableList) {
                drawable.draw(evt.partialTicks);
            }
        }
    }

    public void playerLoggedIn(Player player, NetHandler netHandler, INetworkManager manager) {
    }

    public String connectionReceived(NetLoginHandler netHandler, INetworkManager manager) {
        return null;
    }

    public void connectionOpened(NetHandler netClientHandler, String server, int port, INetworkManager manager) {
    }

    public void connectionOpened(NetHandler netClientHandler, MinecraftServer server, INetworkManager manager) {
    }

    public void connectionClosed(INetworkManager manager) {
    }

    public void clientLoggedIn(NetHandler clientHandler, INetworkManager manager, Packet1Login login) {
        this.drawables.clear();
        this.drawableList.clear();
    }
}

