/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.GateCopy.Utils;

import buildcraft.api.gates.ActionManager;
import buildcraft.transport.TileGenericPipe;
import denoflionsx.GateCopy.GateCopy;
import denoflionsx.GateCopy.Items.ItemGateCopier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class GateUtils {
    public static boolean doesHavePulseAction(NBTTagCompound saveData) {
        return GateUtils.convertActionstoArrayList(saveData).contains(ItemGateCopier.pulser.getId());
    }

    public static ArrayList convertActionstoArrayList(NBTTagCompound saveData) {
        ArrayList t = new ArrayList();
        t.addAll(GateUtils.getActionsMapping(saveData).values());
        return t;
    }

    public static void removePulseAction(NBTTagCompound saveData) {
        HashMap actions = GateUtils.getActionsMapping(saveData);
        for (Map.Entry pairs : actions.entrySet()) {
            if (Integer.valueOf(pairs.getValue().toString()).intValue() != ItemGateCopier.pulser.getId()) continue;
            saveData.func_74768_a("action[" + Integer.valueOf(pairs.getKey().toString()) + "]", 0);
        }
    }

    public static HashMap getActionsMapping(NBTTagCompound saveData) {
        HashMap<Integer, Integer> actions = new HashMap<Integer, Integer>();
        for (int i = 0; i < 7; ++i) {
            actions.put(i, saveData.func_74762_e("action[" + i + "]"));
        }
        return actions;
    }

    public static boolean isGateAutarchic(TileEntity pipe) {
        NBTTagCompound p = new NBTTagCompound();
        pipe.func_70310_b(p);
        return p.func_74775_l("Gate").func_74764_b("Pulser");
    }

    public static void attachPulser(NBTTagCompound save, NBTTagCompound pulser) {
        save.func_74775_l("Gate").func_74766_a("Pulser", pulser);
    }

    public static NBTTagCompound extractPulser(TileGenericPipe pipe) {
        NBTTagCompound p = new NBTTagCompound();
        pipe.func_70310_b(p);
        NBTTagCompound Pulser = p.func_74775_l("Gate").func_74775_l("Pulser");
        return Pulser;
    }

    public static void cleanNBTData(NBTTagCompound tag) {
        int i;
        for (i = 0; i < 4; ++i) {
            tag.func_74757_a("wireSet[" + i + "]", false);
        }
        for (i = 0; i < 5; ++i) {
            tag.func_74768_a("facadeBlocks[" + i + "]", 0);
            tag.func_74768_a("facadeMeta[" + i + "]", 0);
        }
        if (tag.func_74775_l("Gate").func_74764_b("Pulser")) {
            tag.func_74775_l("Gate").func_82580_o("Pulser");
        }
    }

    public static void mergeNBT(NBTTagCompound pipe, NBTTagCompound paste) {
        int x = pipe.func_74762_e("x");
        int y = pipe.func_74762_e("y");
        int z = pipe.func_74762_e("z");
        paste.func_74768_a("x", x);
        paste.func_74768_a("y", y);
        paste.func_74768_a("z", z);
        for (int i = 0; i < 4; ++i) {
            paste.func_74757_a("wireSet[" + i + "]", pipe.func_74767_n("wireSet[" + i + "]"));
        }
    }

    public static boolean isMatchingGateForPaste(TileGenericPipe pipe, NBTTagCompound paste) {
        NBTTagCompound p = new NBTTagCompound();
        pipe.func_70310_b(p);
        int sourceID = p.func_74775_l("Gate").func_74762_e("Kind");
        int compare = paste.func_74775_l("GateType").func_74762_e("ID");
        return compare == sourceID;
    }

    public static String getActionName(int id) {
        return ActionManager.actions[id].getDescription();
    }

    public static String getTriggerName(int id) {
        return ActionManager.triggers[id].getDescription();
    }

    public static class FileIOWrapper {
        public static FileInputStream getStream(File file) {
            try {
                if (file.exists()) {
                    return new FileInputStream(file);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        }

        public static FileOutputStream getOutStream(File file) {
            try {
                return new FileOutputStream(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public static void close(FileInputStream in) {
            try {
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class PropsWrapper {
        public Properties prop = new Properties();
        public FileInputStream stream = null;
        public FileOutputStream outStream = null;

        public void loadFromXML(File file) {
            try {
                if (this.stream == null) {
                    this.stream = FileIOWrapper.getStream(file);
                }
                this.prop.loadFromXML(this.stream);
                this.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void saveToXML(File f) {
            try {
                if (this.outStream == null) {
                    this.outStream = FileIOWrapper.getOutStream(f);
                }
                this.prop.storeToXML(this.outStream, "GateCopy Tooltips");
                this.outStream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void close() {
            FileIOWrapper.close(this.stream);
        }
    }

    public static enum GateEnum {
        None(""),
        Single("Gate"),
        AND_2("Iron AND Gate"),
        OR_2("Iron OR Gate"),
        AND_3("Gold AND Gate"),
        OR_3("Gold OR Gate"),
        AND_4("Diamond AND Gate"),
        OR_4("Diamond AND Gate");

        private String name;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private GateEnum() {
            void name;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class GateNames {
        public static File props = new File(GateCopy.proxy.getConfigDir() + "GateNames.xml");
        public static PropsWrapper Names = new PropsWrapper();

        public static void createProperties() {
            if (props.exists()) {
                Names.loadFromXML(props);
            } else {
                for (GateEnum e : GateEnum.values()) {
                    GateNames.Names.prop.setProperty(e.toString(), e.getName());
                }
                Names.saveToXML(props);
            }
        }
    }
}

