/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.packet.PacketCustom;
import codechicken.core.vec.BlockCoord;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.ItemWirelessFreq;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessBolt;
import java.util.ArrayList;

public class WRCoreSPH
implements PacketCustom.IServerPacketHandler {
    public void handlePacket(PacketCustom packetCustom, jh nethandler, jc sender) {
        this.handlePacket((iz)sender.q, sender, packetCustom);
    }

    private void handlePacket(iz world, jc player, PacketCustom packet) {
        switch (packet.getType()) {
            case 1: {
                this.setTileFreq((sq)player, (aab)world, packet.readCoord(), packet.readShort());
                break;
            }
            case 2: {
                this.setItemFreq(player, packet.readShort(), packet.readShort());
                break;
            }
            case 4: {
                this.handleFreqInfo(packet);
                break;
            }
            case 5: {
                this.decrementSlot(player, packet.readShort());
                break;
            }
            case 9: {
                RedstoneEther.get(false).setFreqOwner(packet.readShort(), packet.readString());
            }
        }
    }

    private void decrementSlot(jc player, int slot) {
        try {
            wm item = player.bK.a[slot];
            --item.a;
            if (item.a == 0) {
                player.bK.a[slot] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void setItemFreq(jc sender, int slot, int freq) {
        wm stack;
        if (RedstoneEther.get(false).canBroadcastOnFrequency((sq)sender, freq) && (stack = sender.bK.a[slot]) != null && stack.b() instanceof ItemWirelessFreq) {
            ((ItemWirelessFreq)stack.b()).setFreq((sq)sender, slot, stack, freq);
        }
    }

    private void setTileFreq(sq sender, aab world, BlockCoord pos, int freq) {
        aqp tile;
        if (RedstoneEther.get(false).canBroadcastOnFrequency(sender, freq) && (tile = RedstoneEther.getTile(world, pos)) instanceof ITileWireless) {
            RedstoneEther.get(false).setFreq((ITileWireless)tile, freq);
        }
    }

    private void handleFreqInfo(PacketCustom packet) {
        int freq = packet.readUnsignedShort();
        String name = packet.readString();
        int colourid = packet.readUnsignedByte();
        RedstoneEther.get(false).setFreqName(freq, name);
        RedstoneEther.get(false).setFreqColour(freq, colourid);
        WRCoreSPH.sendSetFreqInfoTo(null, freq, name, colourid);
    }

    public static void sendSetFrequencyRangeTo(sq player, int startfreq, int endfreq, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 3);
        packet.writeShort((int)((short)startfreq));
        packet.writeShort((int)((short)endfreq));
        packet.writeBoolean(jam);
        packet.sendToPlayer(player);
    }

    public static void sendPublicFrequencyTo(sq player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(1);
        packet.sendToPlayer(player);
    }

    public static void sendSharedFrequencyTo(sq player, int freq) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 2);
        packet.writeShort(freq);
        packet.writeByte(2);
        packet.sendToPlayer(player);
    }

    public static void sendSetFreqInfoTo(sq player, int freq, String name, int colourid) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 4);
        packet.writeShort(freq);
        packet.writeByte(colourid);
        packet.writeString(name);
        packet.sendToPlayer(player);
    }

    public static void sendJamPlayerPacketTo(sq player, boolean jam) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 7);
        packet.writeBoolean(jam);
        packet.sendToPlayer(player);
    }

    public static void sendWirelessBolt(WirelessBolt bolt) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 8);
        packet.writeFloat((float)bolt.start.x);
        packet.writeFloat((float)bolt.start.y);
        packet.writeFloat((float)bolt.start.z);
        packet.writeFloat((float)bolt.end.x);
        packet.writeFloat((float)bolt.end.y);
        packet.writeFloat((float)bolt.end.z);
        packet.writeLong(bolt.seed);
        packet.sendToChunk(bolt.world, (int)bolt.start.x >> 4, (int)bolt.start.z >> 4);
    }

    public static void sendSetSlot(int slot, wm stack) {
    }

    public static void sendFreqInfoTo(sq player, ArrayList<Integer> freqsWithInfo) {
        if (freqsWithInfo.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 1);
        packet.writeShort(freqsWithInfo.size());
        for (int freq : freqsWithInfo) {
            packet.writeShort(freq);
            packet.writeByte(RedstoneEther.get(false).getFreqColourId(freq));
            packet.writeString(RedstoneEther.get(false).getFreqName(freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendFreqOwnerTo(sq player, ArrayList<Integer> freqsWithOwners) {
        if (freqsWithOwners.size() == 0) {
            return;
        }
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 10);
        packet.writeShort(freqsWithOwners.size());
        for (int freq : freqsWithOwners) {
            packet.writeShort(freq);
            packet.writeString(RedstoneEther.get(false).getFreqOwner(freq));
        }
        packet.sendToPlayer(player);
    }

    public static void sendSetFreqOwner(int freq, String username) {
        PacketCustom packet = new PacketCustom((Object)"WRCBE", 9);
        packet.writeShort(freq);
        packet.writeString(username);
        packet.sendToClients();
    }
}

