/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.ServerUtils;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RenderWirelessBolt;
import codechicken.wirelessredstone.core.WirelessBolt;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class WRCoreEventHandler
implements IPlayerTracker,
ITickHandler {
    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.I) {
            RedstoneEther.loadClientEther(event.world);
        } else {
            RedstoneEther.loadServerWorld(event.world);
        }
    }

    @ForgeSubscribe
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        RedstoneEther.loadServerWorld(event.world);
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.I) {
            return;
        }
        RedstoneEther.unloadServerWorld(event.world);
        if (!ServerUtils.mc().m()) {
            RedstoneEther.unloadServer();
        }
    }

    @ForgeSubscribe
    public void onWorldSave(WorldEvent.Save event) {
        if (event.world.I) {
            return;
        }
        RedstoneEther.server().saveEther(event.world);
    }

    @ForgeSubscribe
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.world.I) {
            return;
        }
        if (RedstoneEther.server() != null) {
            RedstoneEther.loadServerWorld(event.world);
            RedstoneEther.server().verifyChunkTransmitters(event.world, event.getChunk().g, event.getChunk().h);
        }
    }

    @ForgeSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        RenderWirelessBolt.render(event.partialTicks, (mp)Minecraft.x().h);
    }

    public void onPlayerLogin(sq player) {
        RedstoneEther.server().resetPlayer(player);
    }

    public void onPlayerChangedDimension(sq player) {
        RedstoneEther.server().resetPlayer(player);
    }

    public void onPlayerLogout(sq player) {
        RedstoneEther.server().removePlayer(player);
    }

    public void onPlayerRespawn(sq player) {
        RedstoneEther.server().resetPlayer(player);
    }

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.CLIENT)) {
            WirelessBolt.update(WirelessBolt.clientboltlist);
        }
        if (type.contains(TickType.SERVER)) {
            WirelessBolt.update(WirelessBolt.serverboltlist);
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.WORLD)) {
            RedstoneEther.server().tick((aab)tickData[0]);
        }
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.WORLD, TickType.CLIENT, TickType.SERVER);
    }

    public String getLabel() {
        return "WR-CBE Core";
    }
}

