/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.CommonUtils;
import codechicken.core.vec.BlockCoord;
import codechicken.wirelessredstone.core.FreqCoord;
import codechicken.wirelessredstone.core.ITileReceiver;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RedstoneEtherServer;
import codechicken.wirelessredstone.core.SaveManager;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class RedstoneEtherFrequency {
    private boolean powered;
    private int freq;
    private RedstoneEther ether;
    private HashMap<Integer, DimensionalNodeTracker> nodetrackers = new HashMap();
    private HashMap<Integer, Integer> activeDimensions = new HashMap();
    private ArrayList<WirelessTransmittingDevice> transmittingdevices = new ArrayList();
    private boolean useTemporarySet = false;
    private int colour = -1;
    private String name = "";

    public RedstoneEtherFrequency(RedstoneEther ether, int freq) {
        this.ether = ether;
        this.freq = freq;
    }

    public void addEther(aab world, int dimension) {
        this.nodetrackers.put(dimension, new DimensionalNodeTracker(world));
    }

    public void remEther(int dimension) {
        this.nodetrackers.remove(dimension);
    }

    public boolean isOn() {
        return this.powered;
    }

    public void saveFreq(int dimension) {
        DimensionalNodeTracker nodetracker = this.nodetrackers.get(dimension);
        if (nodetracker == null || !nodetracker.isdirty) {
            return;
        }
        SaveManager.getInstance(dimension).saveFreq(this.freq, this.getActiveTransmittersInDim(dimension), nodetracker.transmittermap, this.getDimensionHash());
        nodetracker.isdirty = false;
    }

    public void addReceiver(aab world, BlockCoord node, int dimension) {
        if (this.useTemporarySet) {
            this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).temporarySet.add(new DelayedModification(node, 1));
            return;
        }
        this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).receiverset.add(node);
        this.updateReceiver(world, node, this.isOn());
    }

    public void remTransmitter(aab world, BlockCoord node, int dimension) {
        if (this.useTemporarySet) {
            this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).temporarySet.add(new DelayedModification(node, 2));
            return;
        }
        Boolean wason = this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).transmittermap.get(node);
        this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).transmittermap.remove(node);
        if (wason != null && wason.booleanValue()) {
            this.decrementActiveTransmitters(dimension);
            this.nodetrackers.get(dimension).setDirty();
        }
    }

    public void remReceiver(aab world, BlockCoord node, int dimension) {
        if (this.useTemporarySet) {
            this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).temporarySet.add(new DelayedModification(node, 0));
            return;
        }
        this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).receiverset.remove(node);
    }

    public void loadTransmitter(BlockCoord node, int dimension) {
        this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).transmittermap.put(node, true);
        this.incrementActiveTransmitters(dimension);
    }

    public void setTransmitter(aab world, BlockCoord node, int dimension, boolean on) {
        if (this.useTemporarySet) {
            this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).temporarySet.add(new DelayedModification(node, 4 | (on ? 1 : 0)));
            return;
        }
        Boolean wasnodeon = this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).transmittermap.get(node);
        boolean newtransmitter = wasnodeon == null;
        this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).transmittermap.put(node, on);
        if (!newtransmitter && on == wasnodeon) {
            return;
        }
        if (newtransmitter) {
            if (on) {
                this.incrementActiveTransmitters(dimension);
                this.nodetrackers.get(dimension).setDirty();
            }
        } else if (on) {
            this.incrementActiveTransmitters(dimension);
            this.nodetrackers.get(dimension).setDirty();
        } else {
            this.decrementActiveTransmitters(dimension);
            this.nodetrackers.get(dimension).setDirty();
        }
    }

    public void incrementActiveTransmitters(int dimension) {
        this.setActiveTransmittersInDim(dimension, this.getActiveTransmittersInDim(dimension) + 1);
    }

    public void decrementActiveTransmitters(int dimension) {
        this.setActiveTransmittersInDim(dimension, this.getActiveTransmittersInDim(dimension) - 1);
    }

    public void updateAllReceivers() {
        ((RedstoneEtherServer)this.ether).updateReceivingDevices(this.freq, this.powered);
        for (Map.Entry<Integer, DimensionalNodeTracker> entry : this.nodetrackers.entrySet()) {
            int dimension = entry.getKey();
            DimensionalNodeTracker tracker = entry.getValue();
            this.useTemporarySet = true;
            for (BlockCoord coord : tracker.receiverset) {
                this.updateReceiver(tracker.world, coord, this.powered);
            }
            this.useTemporarySet = false;
            while (tracker.temporarySet.size() > 0) {
                DelayedModification mod = tracker.temporarySet.removeFirst();
                if (mod.function == 0) {
                    this.remReceiver(tracker.world, mod.coord, dimension);
                    continue;
                }
                if (mod.function == 1) {
                    this.addReceiver(tracker.world, mod.coord, dimension);
                    continue;
                }
                if (mod.function == 2) {
                    this.remTransmitter(tracker.world, mod.coord, dimension);
                    continue;
                }
                if ((mod.function & 4) == 0) continue;
                this.setTransmitter(tracker.world, mod.coord, dimension, (mod.function & 1) != 0);
            }
        }
    }

    public void updateAllReceivers(DimensionalNodeTracker tracker) {
    }

    public void updateReceiver(aab world, BlockCoord node, boolean on) {
        aqp tileentity = RedstoneEther.getTile(world, node);
        if (tileentity instanceof ITileReceiver) {
            ((ITileReceiver)tileentity).setActive(on);
        } else {
            System.out.println("Null Receiver");
        }
    }

    public void setColour(int colourid) {
        this.colour = colourid;
        if (!this.ether.remote && !SaveManager.isLoading()) {
            if (colourid == -1) {
                SaveManager.freqProp.removeProperty(String.valueOf(this.freq) + ".colour");
            } else {
                SaveManager.freqProp.setProperty(String.valueOf(this.freq) + ".colour", this.colour);
            }
        }
    }

    public int getColourId() {
        return this.colour;
    }

    public void setName(String name) {
        this.name = name;
        if (!this.ether.remote && !SaveManager.isLoading()) {
            if (name == null || name.equals("")) {
                SaveManager.freqProp.removeProperty(String.valueOf(this.freq) + ".name");
            } else {
                SaveManager.freqProp.setProperty(String.valueOf(this.freq) + ".name", name);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setClean(int dimension) {
        this.nodetrackers.get(dimension).isdirty = false;
    }

    public int nodeCount() {
        int count = 0;
        for (Map.Entry<Integer, DimensionalNodeTracker> entry : this.nodetrackers.entrySet()) {
            count += entry.getValue().transmittermap.size() + entry.getValue().receiverset.size();
        }
        return count;
    }

    public TreeSet<BlockCoord> getReceivers(int dimension) {
        return this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).receiverset;
    }

    public TreeMap<BlockCoord, Boolean> getTransmitters(int dimension) {
        return this.nodetrackers.get((Object)Integer.valueOf((int)dimension)).transmittermap;
    }

    public void addTransmittingDevice(WirelessTransmittingDevice device) {
        if (this.transmittingdevices.add(device)) {
            this.incrementActiveTransmitters(device.getDimension());
        }
    }

    public void removeTransmittingDevice(WirelessTransmittingDevice device) {
        if (this.transmittingdevices.remove(device)) {
            this.decrementActiveTransmitters(device.getDimension());
        }
    }

    public List<WirelessTransmittingDevice> getTransmittingDevices() {
        return this.transmittingdevices;
    }

    public void putActiveTransmittersInList(int dimension, ArrayList<FreqCoord> txnodes) {
        DimensionalNodeTracker nodetracker = this.nodetrackers.get(dimension);
        for (BlockCoord node : nodetracker.transmittermap.keySet()) {
            if (!nodetracker.transmittermap.get(node).booleanValue()) continue;
            txnodes.add(new FreqCoord(node, this.freq));
        }
    }

    public int getActiveTransmitters() {
        int num = 0;
        for (Map.Entry<Integer, Integer> entry : this.activeDimensions.entrySet()) {
            num += entry.getValue().intValue();
        }
        return num;
    }

    public int getActiveTransmittersInDim(int dim) {
        Integer val = this.activeDimensions.get(dim);
        if (val == null) {
            val = 0;
            this.activeDimensions.put(dim, 0);
        }
        return val;
    }

    public void setActiveTransmittersInDim(int dim, int num) {
        this.activeDimensions.put(dim, num);
        if (num == 0 == this.powered) {
            boolean nowPowered;
            boolean bl = nowPowered = this.getActiveTransmitters() > 0;
            if (nowPowered != this.powered) {
                this.powered = nowPowered;
                this.updateAllReceivers();
            }
        }
    }

    public Map<Integer, Integer> getDimensionHash() {
        return Collections.unmodifiableMap(this.activeDimensions);
    }

    public static class DelayedModification {
        BlockCoord coord;
        int function;

        public DelayedModification(BlockCoord node, int i) {
            this.coord = node;
            this.function = i;
        }
    }

    public class DimensionalNodeTracker {
        public TreeMap<BlockCoord, Boolean> transmittermap = new TreeMap();
        public TreeSet<BlockCoord> receiverset = new TreeSet();
        public LinkedList<DelayedModification> temporarySet = new LinkedList();
        public aab world;
        public int dimension;
        private boolean isdirty = false;

        public DimensionalNodeTracker(aab world2) {
            this.world = world2;
            this.dimension = CommonUtils.getDimension((aab)world2);
        }

        public void setDirty() {
            if (!this.isdirty) {
                ((RedstoneEtherServer)RedstoneEtherFrequency.this.ether).addFreqToSave(RedstoneEtherFrequency.this, this.dimension);
            }
            this.isdirty = true;
        }
    }
}

