/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.gui.GuiCCButton;
import codechicken.core.gui.GuiCCTextField;
import codechicken.core.gui.GuiScreenWidget;
import codechicken.core.gui.GuiWidget;
import codechicken.wirelessredstone.core.GuiButtonArrow;
import codechicken.wirelessredstone.core.GuiInvItemSlot;
import codechicken.wirelessredstone.core.GuiNameSlot;
import codechicken.wirelessredstone.core.IGuiRemoteUseable;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.ItemWirelessFreq;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.SaveManager;
import codechicken.wirelessredstone.core.WRCoreCPH;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;

public class GuiRedstoneWireless
extends GuiScreenWidget
implements IGuiRemoteUseable {
    RedstoneEther ether = RedstoneEther.get(true);
    private GuiCCTextField textboxname;
    private GuiCCTextField textboxfreq;
    private GuiNameSlot slotnames;
    private GuiInvItemSlot dyeslot;
    private GuiCCButton setfreqbutton;
    private GuiCCButton setnamebutton;
    private GuiCCButton setcolourbutton;
    private int selectedfreq;
    private boolean toggle;
    protected aqp etile;
    protected ITileWireless itile;
    protected ItemWirelessFreq item;
    protected so inventory;
    public boolean largeGui;

    public GuiRedstoneWireless(so inventoryplayer, ITileWireless tileentityredstonewireless) {
        this.itile = tileentityredstonewireless;
        this.etile = (aqp)tileentityredstonewireless;
        this.selectedfreq = this.itile.getFreq();
        this.inventory = inventoryplayer;
    }

    public GuiRedstoneWireless(so inventoryplayer) {
        this.item = (ItemWirelessFreq)inventoryplayer.h().b();
        this.selectedfreq = this.item.getItemFreq(inventoryplayer.h());
        this.inventory = inventoryplayer;
    }

    public void A_() {
        this.largeGui = SaveManager.config().getTag("AdvancedGui").getBooleanValue(false);
        if (this.largeGui) {
            this.xSize = 236;
            this.ySize = 190;
        } else {
            this.xSize = 176;
            this.ySize = 166;
        }
        super.A_();
    }

    public void addWidgets() {
        if (this.largeGui) {
            this.add((GuiWidget)new GuiCCButton(218, 4, 14, 15, "x").setActionCommand("close"));
            this.add((GuiWidget)new GuiCCButton(135, 20, 20, 20, "+").setActionCommand("+1"));
            this.add((GuiWidget)new GuiCCButton(81, 20, 20, 20, "-").setActionCommand("-1"));
            this.add((GuiWidget)new GuiCCButton(158, 20, 20, 20, "+10").setActionCommand("+10"));
            this.add((GuiWidget)new GuiCCButton(58, 20, 20, 20, "-10").setActionCommand("-10"));
            this.add((GuiWidget)new GuiCCButton(180, 20, 26, 20, "+100").setActionCommand("+100"));
            this.add((GuiWidget)new GuiCCButton(29, 20, 26, 20, "-100").setActionCommand("-100"));
            this.add((GuiWidget)new GuiCCButton(174, 42, 32, 20, "+1000").setActionCommand("+1000"));
            this.add((GuiWidget)new GuiCCButton(29, 42, 32, 20, "-1000").setActionCommand("-1000"));
            this.add((GuiWidget)new GuiCCButton(181, 167, 50, 16, "Simple").setActionCommand("toggleSize"));
            this.setfreqbutton = new GuiCCButton(143, 45, 26, 20, "set").setActionCommand("setFreq");
            this.add((GuiWidget)this.setfreqbutton);
            this.setnamebutton = new GuiCCButton(171, 83, 50, 20, "").setActionCommand("setName");
            this.add((GuiWidget)this.setnamebutton);
            this.setcolourbutton = new GuiCCButton(171, 140, 61, 20, "Phase Shift").setActionCommand("setColour");
            this.add((GuiWidget)this.setcolourbutton);
            this.add((GuiWidget)new GuiButtonArrow(182, 122, 12, 12, 3).setActionCommand("nextItem"));
            this.add((GuiWidget)new GuiButtonArrow(208, 122, 12, 12, 1).setActionCommand("prevItem"));
            this.slotnames = new GuiNameSlot(18, 104);
            this.add((GuiWidget)this.slotnames);
            this.textboxfreq = new GuiCCTextField(98, 46, 40, 18, "").setActionCommand("setFreq").setMaxStringLength(4).setAllowedCharacters("0123456789");
            this.add((GuiWidget)this.textboxfreq);
            this.textboxname = new GuiCCTextField(18, 85, 150, 16, "Initial").setActionCommand("setName").setMaxStringLength(20);
            this.add((GuiWidget)this.textboxname);
            this.dyeslot = new GuiInvItemSlot(193, 120, this.inventory, RedstoneEther.getColourSetters(), 14).setActionCommand("setColour");
            this.add(this.dyeslot);
            this.updateColourSetButton();
            this.updateFreqSetButton();
            this.reloadNameText();
            this.updateNames();
        } else {
            this.add((GuiWidget)new GuiCCButton(157, 6, 14, 15, "x").setActionCommand("close"));
            this.add((GuiWidget)new GuiCCButton(101, 33, 20, 20, "+").setActionCommand("+1"));
            this.add((GuiWidget)new GuiCCButton(55, 33, 20, 20, "-").setActionCommand("-1"));
            this.add((GuiWidget)new GuiCCButton(123, 33, 20, 20, "+10").setActionCommand("+10"));
            this.add((GuiWidget)new GuiCCButton(33, 33, 20, 20, "-10").setActionCommand("-10"));
            this.add((GuiWidget)new GuiCCButton(145, 33, 26, 20, "+100").setActionCommand("+100"));
            this.add((GuiWidget)new GuiCCButton(5, 33, 26, 20, "-100").setActionCommand("-100"));
            this.add((GuiWidget)new GuiCCButton(127, 55, 32, 20, "+1000").setActionCommand("+1000"));
            this.add((GuiWidget)new GuiCCButton(18, 55, 32, 20, "-1000").setActionCommand("-1000"));
            this.add((GuiWidget)new GuiCCButton(61, 68, 54, 16, "Advanced").setActionCommand("toggleSize"));
        }
    }

    public void c() {
        if (this.itile != null && this.g.e.r(this.etile.l, this.etile.m, this.etile.n) != this.etile) {
            this.g.s = null;
            this.g.h();
        }
        super.c();
        if (this.toggle) {
            this.largeGui = !this.largeGui;
            SaveManager.config().getTag("AdvancedGui").setBooleanValue(this.largeGui);
            this.reset();
            this.toggle = false;
        }
        if (this.largeGui) {
            this.updateColourSetButton();
            this.updateFreqSetButton();
            this.updateNames();
        }
    }

    public void a(int mousex, int mousey, float f) {
        this.e();
        super.a(mousex, mousey, f);
    }

    public void drawForeground() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        if (this.largeGui) {
            String name = this.getSetObjectName();
            this.m.b(name, 118 - this.m.a(name) / 2, 5, 0x303030);
            this.m.b("Value", 69, 51, 0x404040);
            this.m.b("Frequency Name", 53, 74, 0x404040);
            this.m.b("Spectrum", 178, 107, this.ether.getFreqColour(this.selectedfreq));
            int actualfreq = this.getSetObjectFreq();
            String sactualfreq = Integer.toString(actualfreq);
            String sselectedfreq = Integer.toString(this.selectedfreq);
            if (!this.ether.canBroadcastOnFrequency((sq)this.g.g, this.selectedfreq)) {
                this.m.b(sselectedfreq, 118 - this.m.a(sselectedfreq) / 2, 23, 0xFF4040);
                this.m.b(sactualfreq, 118 - this.m.a(sactualfreq) / 2, 33, 0x4040FF);
            } else {
                this.m.b(sactualfreq, 118 - this.m.a(sactualfreq) / 2, 26, 0xFFFFFF);
            }
        } else {
            String name = this.getSetObjectName();
            this.m.b(name, 88 - this.m.a(name) / 2, 5, 0x303030);
            this.m.b("Frequency", 88 - this.m.a("Frequency") / 2, 16, 0x404040);
            int actualfreq = this.getSetObjectFreq();
            String sactualfreq = Integer.toString(actualfreq);
            String sselectedfreq = Integer.toString(this.selectedfreq);
            if (!this.ether.canBroadcastOnFrequency((sq)this.g.g, this.selectedfreq)) {
                this.m.b(sselectedfreq, 88 - this.m.a(sselectedfreq) / 2, 36, 0xFF4040);
                this.m.b(sactualfreq, 88 - this.m.a(sactualfreq) / 2, 46, 0x4040FF);
            } else {
                this.m.b(sactualfreq, 88 - this.m.a(sactualfreq) / 2, 39, 0xFFFFFF);
            }
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    private void updateFreqSetButton() {
        int i;
        String s = this.textboxfreq.getText();
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            i = -1;
        }
        this.setfreqbutton.setEnabled(i >= 0 && i <= 5000);
    }

    private void updateColourSetButton() {
        int selected = this.dyeslot.getSelectedIndex();
        if (selected == -1) {
            this.setcolourbutton.setEnabled(false);
            return;
        }
        if (selected == 14) {
            selected = -1;
        }
        this.setcolourbutton.setEnabled(this.selectedfreq != 0 && selected != this.ether.getFreqColourId(this.selectedfreq) && this.ether.canBroadcastOnFrequency((sq)this.g.g, this.selectedfreq));
    }

    private boolean nameIsUsed(String name) {
        ArrayList<String> names = this.ether.getAllNames();
        return names.contains(name);
    }

    private void updateNames() {
        String name = this.ether.getFreqName(this.selectedfreq);
        String tname = this.textboxname.getText();
        boolean set = name == null || name.equals("") || !name.equals(tname);
        boolean canset = !tname.equals("") && !this.nameIsUsed(tname) && this.selectedfreq != 0;
        this.setnamebutton.setEnabled((set && canset || !set) && this.ether.canBroadcastOnFrequency((sq)this.g.g, this.selectedfreq));
        String string = this.setnamebutton.text = set ? "Set Name" : "Remove";
        if (set) {
            this.slotnames.updateNameList((sq)this.g.g, this.textboxname.getText());
        } else if (name.equals(tname)) {
            this.slotnames.updateNameList((sq)this.g.g, "");
            this.slotnames.removeName(tname);
        } else {
            this.slotnames.clearNameList();
        }
    }

    private void reloadNameText() {
        String name = this.ether.getFreqName(this.selectedfreq);
        if (name == null) {
            name = "";
        }
        this.textboxname.setText(name);
    }

    public void actionPerformed(String ident, Object ... params) {
        if (ident.equals("close")) {
            this.g.a(null);
            this.g.h();
        } else if (ident.startsWith("+") || ident.startsWith("-")) {
            this.selectedfreq += Integer.parseInt(ident.startsWith("+") ? ident.substring(1) : ident);
            if (this.selectedfreq > 5000) {
                this.selectedfreq -= 5001;
            }
            if (this.selectedfreq < 0) {
                this.selectedfreq += 5001;
            }
            this.setNewFreq();
        } else if (ident.equals("toggleSize")) {
            this.toggle = true;
        } else if (ident.equals("setFreq")) {
            this.selectedfreq = Integer.parseInt(this.textboxfreq.getText());
            this.setNewFreq();
        } else if (ident.equals("setName")) {
            if (this.setnamebutton.isEnabled()) {
                if (this.setnamebutton.text.equals("Set Name")) {
                    this.ether.setFreqName(this.selectedfreq, this.textboxname.getText());
                    WRCoreCPH.sendSetFreqInfo(this.selectedfreq, this.textboxname.getText(), this.ether.getFreqColourId(this.selectedfreq));
                } else {
                    this.ether.setFreqName(this.selectedfreq, "");
                    WRCoreCPH.sendSetFreqInfo(this.selectedfreq, "", this.ether.getFreqColourId(this.selectedfreq));
                    this.textboxname.setText("");
                }
            }
        } else if (ident.equals("setColour")) {
            int colourid = this.dyeslot.getSelectedIndex();
            if (colourid == -1) {
                return;
            }
            if (colourid == 14) {
                colourid = -1;
            }
            if (colourid == this.ether.getFreqColourId(this.selectedfreq)) {
                return;
            }
            this.dyeslot.decrementCurrentStack();
            this.ether.setFreqColour(this.selectedfreq, colourid);
            WRCoreCPH.sendSetFreqInfo(this.selectedfreq, this.ether.getFreqName(this.selectedfreq), colourid);
        } else if (ident.equals("nextItem")) {
            this.dyeslot.cycleNextItem();
        } else if (ident.equals("prevItem")) {
            this.dyeslot.cyclePrevItem();
        } else if (ident.equals("selectName")) {
            String slotname = this.slotnames.getSelectedName();
            if (slotname.equals("")) {
                return;
            }
            int freq = this.ether.getFreqByName(slotname);
            if (freq != -1) {
                this.selectedfreq = freq;
                this.setNewFreq();
            }
        }
    }

    private void setNewFreq() {
        if (this.ether.canBroadcastOnFrequency((sq)this.g.g, this.selectedfreq)) {
            if (this.itile == null) {
                this.item.setFreq(this.inventory.d, this.inventory.c, this.inventory.h(), this.selectedfreq);
            } else {
                RedstoneEther.get(true).setFreq(this.itile, this.selectedfreq);
            }
        }
        if (this.largeGui) {
            this.reloadNameText();
        }
    }

    private String getSetObjectName() {
        return this.itile == null ? this.item.getGuiName() : this.itile.getGuiName();
    }

    private int getSetObjectFreq() {
        return this.itile == null ? this.item.getItemFreq(this.inventory.h()) : this.itile.getFreq();
    }

    public void drawBackground() {
        if (this.largeGui) {
            this.g.p.b("/codechicken/wirelessredstone/core/guiWirelessLarge.png");
        } else {
            this.g.p.b("/codechicken/wirelessredstone/core/guiWirelessSmall.png");
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.b(0, 0, 0, 0, this.xSize, this.ySize);
    }

    public boolean f() {
        return false;
    }
}

