/*
 * Decompiled with CFR 0.152.
 */
package lib.org.modstats;

import cpw.mods.fml.common.FMLLog;
import lib.org.modstats.IModstatsReporter;

public class Modstats {
    private static final Modstats INSTANCE = new Modstats();
    private static final String CLASS_TEMPLATE = "lib.org.modstats.reporter.v%d.Reporter";
    private final IModstatsReporter reporter = this.locateReporter();

    private Modstats() {
    }

    public IModstatsReporter getReporter() {
        return this.reporter;
    }

    private IModstatsReporter locateReporter() {
        Class<?> latest = null;
        for (int i = 1; i < 100; ++i) {
            try {
                Class<?> candidate = Class.forName(String.format(CLASS_TEMPLATE, i));
                if (!IModstatsReporter.class.isAssignableFrom(candidate)) continue;
                latest = candidate;
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        if (latest == null) {
            FMLLog.warning((String)"Modstats reporter class not found.", (Object[])new Object[0]);
        } else {
            try {
                return (IModstatsReporter)latest.newInstance();
            }
            catch (Exception e) {
                FMLLog.warning((String)"Modstats reporter class can't be instantiated.", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static Modstats instance() {
        return INSTANCE;
    }
}

