/*
 * Decompiled with CFR 0.152.
 */
package lib.cofh.util;

import lib.cofh.util.MathHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemHelper {
    private ItemHelper() {
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static ItemStack findMatchingRecipe(InventoryCrafting inv, World world) {
        ItemStack[] dmgItems = new ItemStack[2];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            if (dmgItems[0] == null) {
                dmgItems[0] = inv.func_70301_a(i);
                continue;
            }
            dmgItems[1] = inv.func_70301_a(i);
            break;
        }
        if (dmgItems[1] != null && dmgItems[0].field_77993_c == dmgItems[1].field_77993_c && dmgItems[0].field_77994_a == 1 && dmgItems[1].field_77994_a == 1 && Item.field_77698_e[dmgItems[0].field_77993_c].isRepairable()) {
            Item theItem = Item.field_77698_e[dmgItems[0].field_77993_c];
            int var13 = theItem.func_77612_l() - dmgItems[0].func_77952_i();
            int var8 = theItem.func_77612_l() - dmgItems[1].func_77952_i();
            int var9 = var13 + var8 + theItem.func_77612_l() * 5 / 100;
            int var10 = MathHelper.maxI(0, theItem.func_77612_l() - var9);
            return new ItemStack(dmgItems[0].field_77993_c, 1, var10);
        }
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe.func_77572_b(inv);
        }
        return null;
    }

    public static int getHashCode(ItemStack stack) {
        return stack.func_77960_j() | stack.field_77993_c << 16;
    }

    public static int getHashCode(int id, int metadata) {
        return metadata | id << 16;
    }

    public static int getIDFromHashCode(int hashCode) {
        return hashCode >> 16;
    }

    public static int getMetaFromHashCode(int hashCode) {
        return hashCode & 0xFF;
    }

    public static String getOreName(ItemStack stack) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack));
    }

    public static boolean isOreID(ItemStack stack, int oreID) {
        return OreDictionary.getOreID((ItemStack)stack) == oreID;
    }

    public static boolean isOreName(ItemStack stack, String oreName) {
        return OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)stack)).equals(oreName);
    }

    public static boolean isPlayerHoldingItem(Item item, EntityPlayer player) {
        Item equipped;
        Item item2 = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return item == null ? equipped == null : item.equals(equipped);
    }

    public static boolean isPlayerHoldingItemStack(ItemStack stack, EntityPlayer player) {
        ItemStack equipped;
        ItemStack itemStack = equipped = player.func_71045_bC() != null ? player.func_71045_bC() : null;
        return stack == null ? equipped == null : equipped != null && stack.func_77969_a(equipped) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)equipped);
    }

    public static ItemStack[] cloneInventory(ItemStack[] stacks) {
        ItemStack[] inventoryCopy = new ItemStack[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            inventoryCopy[i] = stacks[i] == null ? null : stacks[i].func_77946_l();
        }
        return inventoryCopy;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex) {
        if (stack == null) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i < inventory.length; ++i) {
            if (ItemHelper.areItemStacksEqualNoNBT(stack, inventory[i]) && inventory[i].func_77976_d() > inventory[i].field_77994_a) {
                int hold = inventory[i].func_77976_d() - inventory[i].field_77994_a;
                if (hold >= stack.field_77994_a) {
                    inventory[i].field_77994_a += stack.field_77994_a;
                    stack = null;
                    return true;
                }
                stack.field_77994_a -= hold;
                inventory[i].field_77994_a += hold;
                continue;
            }
            if (inventory[i] != null || openSlot != -1) continue;
            openSlot = i;
        }
        if (stack != null) {
            if (openSlot > -1) {
                inventory[openSlot] = stack;
            } else {
                return false;
            }
        }
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        return ItemHelper.addItemStackToInventory(inventory, stack, 0);
    }

    public static boolean areItemStacksEqualNoNBT(ItemStack stackA, ItemStack stackB) {
        if (stackB == null) {
            return false;
        }
        return stackA.field_77993_c == stackB.field_77993_c && (stackA.func_77960_j() == Short.MAX_VALUE || stackB.func_77960_j() == Short.MAX_VALUE || !stackA.func_77981_g() || stackB.func_77960_j() == stackA.func_77960_j());
    }

    public static boolean craftingEquivalence(ItemStack checked, ItemStack source, String oreDict) {
        return ItemHelper.areItemStacksEqualNoNBT(checked, source) ? true : (oreDict == null ? false : ItemHelper.getOreName(checked).equalsIgnoreCase(oreDict));
    }
}

