/*
 * Decompiled with CFR 0.152.
 */
package lib.cofh.util;

import java.io.Serializable;
import lib.cofh.util.BlockCoord;
import lib.cofh.util.BlockHelper;
import net.minecraft.world.chunk.Chunk;

public final class ChunkCoord
implements Comparable,
Serializable {
    private static final long serialVersionUID = -624987597053791872L;
    public int chunkX;
    public int chunkZ;

    public ChunkCoord(Chunk chunk) {
        this.chunkX = chunk.field_76635_g;
        this.chunkZ = chunk.field_76647_h;
    }

    public ChunkCoord(BlockCoord c) {
        this(c.x >> 4, c.z >> 4);
    }

    public ChunkCoord(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
    }

    public int getCenterX() {
        return (this.chunkX << 4) + 8;
    }

    public int getCenterZ() {
        return (this.chunkZ << 4) + 8;
    }

    public void step(int dir) {
        this.chunkX = BlockHelper.SIDE_COORD_MOD[dir][0];
        this.chunkZ = BlockHelper.SIDE_COORD_MOD[dir][2];
    }

    public void step(int dir, int dist) {
        switch (dir) {
            case 2: {
                this.chunkZ -= dist;
                break;
            }
            case 3: {
                this.chunkZ += dist;
                break;
            }
            case 4: {
                this.chunkX -= dist;
                break;
            }
            case 5: {
                this.chunkX += dist;
                break;
            }
        }
    }

    public ChunkCoord copy() {
        return new ChunkCoord(this.chunkX, this.chunkZ);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkCoord)) {
            return false;
        }
        ChunkCoord other = (ChunkCoord)obj;
        return this.chunkX == other.chunkX && this.chunkZ == other.chunkZ;
    }

    public int hashCode() {
        int hash = this.chunkX;
        return hash *= 31 + this.chunkZ;
    }

    public String toString() {
        return "[" + this.chunkX + ", " + this.chunkZ + "]";
    }

    public int compareTo(ChunkCoord other) {
        return this.chunkX == other.chunkX ? this.chunkZ - other.chunkZ : this.chunkX - other.chunkX;
    }
}

