/*
 * Decompiled with CFR 0.152.
 */
package lib.cofh.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public final class BlockHelper {
    public static byte[] rotateType = new byte[4096];
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};
    public static final int[] SIDE_LEFT = new int[]{4, 5, 5, 4, 2, 3};
    public static final int[] SIDE_RIGHT = new int[]{5, 4, 4, 5, 3, 2};
    public static final int[] SIDE_OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};
    public static final int[] SIDE_ABOVE = new int[]{2, 3, 1, 1, 1, 1};
    public static final int[] SIDE_BELOW = new int[]{3, 2, 0, 0, 0, 0};

    private BlockHelper() {
    }

    public static int getCurrentMousedOverSide(World world, EntityPlayer player) {
        double distance = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3 posVec = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        Vec3 lookVec = player.func_70676_i(1.0f);
        posVec.field_72448_b += (double)player.func_70047_e();
        lookVec = posVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        MovingObjectPosition mouseOver = player.field_70170_p.func_72933_a(posVec, lookVec);
        if (mouseOver != null) {
            return mouseOver.field_72310_e;
        }
        return 0;
    }

    public static TileEntity getAdjacentTileEntity(World world, int x, int y, int z, ForgeDirection dir) {
        return world.func_72796_p(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
    }

    public static TileEntity getAdjacentTileEntity(World world, int x, int y, int z, int side) {
        return BlockHelper.getAdjacentTileEntity(world, x, y, z, ForgeDirection.values()[side]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, ForgeDirection dir) {
        return BlockHelper.getAdjacentTileEntity(refTile.field_70331_k, refTile.field_70329_l, refTile.field_70330_m, refTile.field_70327_n, dir);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, int side) {
        return BlockHelper.getAdjacentTileEntity(refTile.field_70331_k, refTile.field_70329_l, refTile.field_70330_m, refTile.field_70327_n, ForgeDirection.values()[side]);
    }

    public static int[] getAdjacentCoordinatesForSide(int x, int y, int z, int side) {
        return new int[]{x + SIDE_COORD_MOD[side][0], y + SIDE_COORD_MOD[side][1], z + SIDE_COORD_MOD[side][2]};
    }

    public static int[] getAdjacentCoordinatesForSide(TileEntity tile, int side) {
        return new int[]{tile.field_70329_l + SIDE_COORD_MOD[side][0], tile.field_70330_m + SIDE_COORD_MOD[side][1], tile.field_70327_n + SIDE_COORD_MOD[side][2]};
    }

    public static int getLeftSide(int side) {
        return SIDE_LEFT[side];
    }

    public static int getRightSide(int side) {
        return SIDE_RIGHT[side];
    }

    public static int getOppositeSide(int side) {
        return SIDE_OPPOSITE[side];
    }

    public static int getAboveSide(int side) {
        return SIDE_ABOVE[side];
    }

    public static int getBelowSide(int side) {
        return SIDE_BELOW[side];
    }

    public static boolean canRotate(int blockId) {
        return rotateType[blockId] != 0;
    }

    public static int rotateVanillaBlock(World world, int bId, int bMeta, int x, int y, int z) {
        switch (rotateType[bId]) {
            case 1: {
                return SIDE_LEFT[bMeta];
            }
            case 2: {
                if (bMeta < 6) {
                    return ++bMeta % 6;
                }
                return bMeta;
            }
            case 3: {
                if (bMeta < 2) {
                    return ++bMeta % 2;
                }
                return bMeta;
            }
            case 4: {
                return ++bMeta % 4;
            }
            case 5: {
                return ++bMeta % 8;
            }
            case 6: {
                int upper = bMeta & 0xC;
                int lower = bMeta & 3;
                return upper + ++lower % 4;
            }
            case 7: {
                return (bMeta + 4) % 12;
            }
            case 8: {
                return (bMeta + 8) % 16;
            }
            case 9: {
                int[] coords = new int[3];
                for (int i = 2; i < 6; ++i) {
                    coords = BlockHelper.getAdjacentCoordinatesForSide(x, y, z, i);
                    if (world.func_72798_a(coords[0], coords[1], coords[2]) != Block.field_72077_au.field_71990_ca) continue;
                    world.func_72921_c(coords[0], coords[1], coords[2], SIDE_OPPOSITE[bMeta], 1);
                    return SIDE_OPPOSITE[bMeta];
                }
                return SIDE_LEFT[bMeta];
            }
            case 10: {
                int shift = 0;
                if (bMeta > 7) {
                    bMeta -= 8;
                    shift = 8;
                }
                if (bMeta == 5) {
                    return 6 + shift;
                }
                if (bMeta == 6) {
                    return 5 + shift;
                }
                if (bMeta == 7) {
                    return 0 + shift;
                }
                if (bMeta == 0) {
                    return 7 + shift;
                }
                return bMeta + shift;
            }
            case 11: {
                return ++bMeta % 16;
            }
        }
        return bMeta;
    }

    public static int rotateVanillaBlockAlt(World world, int bId, int bMeta, int x, int y, int z) {
        switch (rotateType[bId]) {
            case 1: {
                return SIDE_RIGHT[bMeta];
            }
            case 2: {
                if (bMeta < 6) {
                    return (bMeta + 5) % 6;
                }
                return bMeta;
            }
            case 3: {
                if (bMeta < 2) {
                    return ++bMeta % 2;
                }
                return bMeta;
            }
            case 4: {
                return (bMeta + 3) % 4;
            }
            case 5: {
                return (bMeta + 7) % 8;
            }
            case 6: {
                int upper = bMeta & 0xC;
                int lower = bMeta & 3;
                return upper + (lower + 3) % 4;
            }
            case 7: {
                return (bMeta + 8) % 12;
            }
            case 8: {
                return (bMeta + 8) % 16;
            }
            case 9: {
                int[] coords = new int[3];
                for (int i = 2; i < 6; ++i) {
                    coords = BlockHelper.getAdjacentCoordinatesForSide(x, y, z, i);
                    if (world.func_72798_a(coords[0], coords[1], coords[2]) != Block.field_72077_au.field_71990_ca) continue;
                    world.func_72921_c(coords[0], coords[1], coords[2], SIDE_OPPOSITE[bMeta], 1);
                    return SIDE_OPPOSITE[bMeta];
                }
                return SIDE_RIGHT[bMeta];
            }
            case 10: {
                int shift = 0;
                if (bMeta > 7) {
                    bMeta -= 8;
                    shift = 8;
                }
                if (bMeta == 5) {
                    return 6 + shift;
                }
                if (bMeta == 6) {
                    return 5 + shift;
                }
                if (bMeta == 7) {
                    return 0 + shift;
                }
                if (bMeta == 0) {
                    return 7 + shift;
                }
            }
            case 11: {
                return ++bMeta % 16;
            }
        }
        return bMeta;
    }

    public static boolean isBlock(int bId) {
        return bId < 0 || bId >= Block.field_71973_m.length ? null : Boolean.valueOf(Block.field_71973_m[bId] != null);
    }

    public static List breakBlock(World worldObj, int x, int y, int z, int blockId, int fortune, boolean doBreak) {
        if (Block.field_71973_m[blockId].func_71934_m(worldObj, x, y, z) == -1.0f) {
            return new LinkedList();
        }
        int meta = worldObj.func_72805_g(x, y, z);
        ArrayList stacks = Block.field_71973_m[blockId].getBlockDropped(worldObj, x, y, z, meta, fortune);
        if (!doBreak) {
            return stacks;
        }
        worldObj.func_72889_a(null, 2001, x, y, z, blockId + (meta << 12));
        worldObj.func_94575_c(x, y, z, 0);
        List result = worldObj.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 2), (double)(y - 2), (double)(z - 2), (double)(x + 3), (double)(y + 3), (double)(z + 3)));
        for (int i = 0; i < result.size(); ++i) {
            if (!(result.get(i) instanceof EntityItem)) continue;
            EntityItem entity = (EntityItem)result.get(i);
            if (entity.field_70128_L || entity.func_92059_d().field_77994_a <= 0) continue;
            stacks.add(entity.func_92059_d());
            entity.field_70170_p.func_72900_e((Entity)entity);
        }
        return stacks;
    }

    static {
        BlockHelper.rotateType[Block.field_71951_J.field_71990_ca] = 7;
        BlockHelper.rotateType[Block.field_71958_P.field_71990_ca] = 2;
        BlockHelper.rotateType[Block.field_71954_T.field_71990_ca] = 3;
        BlockHelper.rotateType[Block.field_71953_U.field_71990_ca] = 3;
        BlockHelper.rotateType[Block.field_71956_V.field_71990_ca] = 2;
        BlockHelper.rotateType[Block.field_71963_Z.field_71990_ca] = 2;
        BlockHelper.rotateType[Block.field_72079_ak.field_71990_ca] = 8;
        BlockHelper.rotateType[Block.field_72063_at.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_72077_au.field_71990_ca] = 9;
        BlockHelper.rotateType[Block.field_72051_aB.field_71990_ca] = 1;
        BlockHelper.rotateType[Block.field_72052_aC.field_71990_ca] = 1;
        BlockHelper.rotateType[Block.field_72053_aD.field_71990_ca] = 11;
        BlockHelper.rotateType[Block.field_72056_aG.field_71990_ca] = 3;
        BlockHelper.rotateType[Block.field_72057_aH.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_72043_aJ.field_71990_ca] = 10;
        BlockHelper.rotateType[Block.field_72061_ba.field_71990_ca] = 4;
        BlockHelper.rotateType[Block.field_72008_bf.field_71990_ca] = 4;
        BlockHelper.rotateType[Block.field_72010_bh.field_71990_ca] = 6;
        BlockHelper.rotateType[Block.field_72011_bi.field_71990_ca] = 6;
        BlockHelper.rotateType[Block.field_71992_bw.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_71995_bx.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_72100_bC.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_72092_bO.field_71990_ca] = 8;
        BlockHelper.rotateType[Block.field_72088_bQ.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_72066_bS.field_71990_ca] = 1;
        BlockHelper.rotateType[Block.field_72074_bW.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_72072_bX.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_72070_bY.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_94338_cu.field_71990_ca] = 5;
        BlockHelper.rotateType[Block.field_94340_cs.field_71990_ca] = 2;
        BlockHelper.rotateType[Block.field_94337_cv.field_71990_ca] = 3;
        BlockHelper.rotateType[Block.field_96469_cy.field_71990_ca] = 2;
    }

    public static final class RotationType {
        public static final int FOUR_WAY = 1;
        public static final int SIX_WAY = 2;
        public static final int RAIL = 3;
        public static final int PUMPKIN = 4;
        public static final int STAIRS = 5;
        public static final int REDSTONE = 6;
        public static final int LOG = 7;
        public static final int SLAB = 8;
        public static final int CHEST = 9;
        public static final int LEVER = 10;
        public static final int SIGN = 11;
    }
}

