/*
 * Decompiled with CFR 0.152.
 */
package lib.cofh.gui.element;

import cpw.mods.fml.client.FMLClientHandler;
import lib.cofh.gui.GuiBase;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.gui.FontRenderer;

public abstract class ElementBase {
    public static final SoundManager elementSoundManager = FMLClientHandler.instance().getClient().field_71416_A;
    public static final FontRenderer elementFontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
    protected GuiBase gui;
    protected String texture;
    protected int posX;
    protected int posY;
    protected int sizeX;
    protected int sizeY;
    public int texW = 256;
    public int texH = 256;
    protected boolean visible = true;

    public ElementBase(GuiBase gui, int posX, int posY) {
        this.gui = gui;
        this.posX = gui.field_74198_m + posX;
        this.posY = gui.field_74197_n + posY;
    }

    public ElementBase setTexture(String texture, int texW, int texH) {
        this.texture = texture;
        this.texW = texW;
        this.texH = texH;
        return this;
    }

    public ElementBase setPosition(int posX, int posY) {
        this.posX = this.gui.field_74198_m + posX;
        this.posY = this.gui.field_74197_n + posY;
        return this;
    }

    public ElementBase setSize(int sizeX, int sizeY) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        return this;
    }

    public ElementBase setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void update() {
    }

    public abstract void draw();

    public void draw(int x, int y) {
        this.posX = x;
        this.posY = y;
        this.draw();
    }

    public abstract String getTooltip();

    public boolean intersectsWith(int mouseX, int mouseY) {
        return (mouseX += this.gui.field_74198_m) >= this.posX && mouseX <= this.posX + this.sizeX && (mouseY += this.gui.field_74197_n) >= this.posY && mouseY <= this.posY + this.sizeY;
    }

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.gui.drawSizedTexturedModalRect(x, y, u, v, width, height, this.texW, this.texH);
    }
}

