/*
 * Decompiled with CFR 0.152.
 */
package lib.cofh.gui;

import java.util.ArrayList;
import lib.cofh.gui.TabTracker;
import lib.cofh.gui.element.ElementBase;
import lib.cofh.gui.element.TabBase;
import lib.cofh.gui.render.IconRegistry;
import lib.cofh.gui.render.RenderHelper;
import lib.cofh.util.MathHelper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.util.Icon;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    public static final String PATH_ELEMENTS = "/mods/lib/textures/gui/elements/";
    public static final String PATH_ICONS = "/mods/lib/textures/gui/icons/";
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected String name;
    protected String texture;
    protected ArrayList tabs = new ArrayList();
    protected ArrayList elements = new ArrayList();

    public GuiBase(Container container) {
        super(container);
    }

    public GuiBase(Container container, String texture) {
        super(container);
        this.texture = texture;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs.clear();
        this.elements.clear();
    }

    protected void func_74189_g(int x, int y) {
        GL11.glDisable((int)2896);
        this.drawTooltips();
        GL11.glEnable((int)2896);
    }

    protected void func_74185_a(float f, int x, int y) {
        this.updateElements();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_98187_b(this.texture);
        this.func_73729_b(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, this.field_74195_c);
        this.drawElements();
        this.drawTabs();
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        super.func_73864_a(x, y, mouseButton);
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null && !tab.handleMouseClicked(this.mouseX, this.mouseY, mouseButton)) {
            for (TabBase other : this.tabs) {
                if (other == tab || !other.open || other.side != tab.side) continue;
                other.toggleOpen();
            }
            tab.toggleOpen();
        }
    }

    public void func_73867_d() {
        int x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        int y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1;
        this.mouseX = x - this.field_74198_m;
        this.mouseY = y - this.field_74197_n;
        super.func_73867_d();
    }

    protected void drawElements() {
        for (ElementBase element : this.elements) {
            element.draw();
        }
    }

    protected void drawTabs() {
        int yPosRight = 4;
        int yPosLeft = 4;
        for (TabBase tab : this.tabs) {
            tab.update();
            if (!tab.isVisible()) continue;
            if (tab.side == 0) {
                tab.draw(this.field_74198_m, this.field_74197_n + yPosLeft);
                yPosLeft += tab.currentHeight;
                continue;
            }
            tab.draw(this.field_74198_m + this.field_74194_b, this.field_74197_n + yPosRight);
            yPosRight += tab.currentHeight;
        }
    }

    protected void drawTooltips() {
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null) {
            this.drawTooltip(tab.getTooltip());
            return;
        }
        ElementBase element = this.getElementAtPosition(this.mouseX, this.mouseY);
        if (element != null) {
            this.drawTooltip(element.getTooltip());
            return;
        }
    }

    public ElementBase addElement(ElementBase element) {
        this.elements.add(element);
        return element;
    }

    public TabBase addTab(TabBase tab) {
        this.tabs.add(tab);
        if (TabTracker.getOpenedLeftTab() != null && tab.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tab.getClass().equals(TabTracker.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        for (ElementBase element : this.elements) {
            if (!element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    protected TabBase getTabAtPosition(int mX, int mY) {
        int xShift = 0;
        int yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 1) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        xShift = this.field_74194_b;
        yShift = 4;
        for (TabBase tab : this.tabs) {
            if (!tab.isVisible() || tab.side == 0) continue;
            tab.currentShiftX = xShift;
            tab.currentShiftY = yShift;
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        return null;
    }

    protected void updateElements() {
    }

    public void drawButton(Icon icon, int x, int y, int spriteSheet, int mode) {
        this.drawIcon(icon, x, y, spriteSheet);
    }

    public void drawButton(String iconName, int x, int y, int spriteSheet, int mode) {
        this.drawButton(IconRegistry.getIcon(iconName), x, y, spriteSheet, mode);
    }

    public void drawTiledTexture(int x, int y, Icon icon, int width, int height) {
        int i = 0;
        int j = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (i = 0; i < width; i += 16) {
            for (j = 0; j < height; j += 16) {
                drawWidth = MathHelper.minI(width - i, 16);
                drawHeight = MathHelper.minI(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawIcon(Icon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_94065_a(x, y, icon, 16, 16);
    }

    public void drawIcon(String iconName, int x, int y, int spriteSheet) {
        this.drawIcon(IconRegistry.getIcon(iconName), x, y, spriteSheet);
    }

    public void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + height) * texV));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + width) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(u + 0) * texU), (double)((float)(v + 0) * texV));
        tessellator.func_78381_a();
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, Icon icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, minU, minV);
        tessellator.func_78381_a();
    }

    public void drawTooltip(String tooltip) {
        if (tooltip == null || tooltip.equals("")) {
            return;
        }
        this.func_74190_a(tooltip, this.mouseX, this.mouseY);
    }

    public void mouseClicked(int mouseButton) {
        super.func_73864_a(this.field_74198_m + this.mouseX, this.field_74197_n + this.mouseY, mouseButton);
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.field_74194_b);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.field_73886_k.func_78256_a(string)) / 2;
    }
}

