/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_world.generator;

import ccm.nucleum_omnium.NucleumOmnium;
import ccm.nucleum_omnium.handler.LogHandler;
import ccm.nucleum_world.utils.TickHandlerWorld;
import ccm.nucleum_world.utils.lib.Properties;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import lib.cofh.api.world.IFeatureGenerator;
import lib.cofh.api.world.IFeatureHandler;
import lib.cofh.util.ChunkCoord;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.ChunkDataEvent;

public class WorldGenHandler
implements IWorldGenerator,
IFeatureHandler {
    private final List ores = new ArrayList();
    private final HashSet oreNames = new HashSet();
    private final HashSet dimensionBlacklist = new HashSet();
    public static WorldGenHandler instance = new WorldGenHandler();

    @ForgeSubscribe
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound tag = new NBTTagCompound();
        if (Properties.retroFlatBedrock && Properties.genFlatBedrock) {
            tag.func_74757_a("CCM-Bedrock", true);
        }
        if (Properties.retroOreGen) {
            tag.func_74757_a("CCM-Ores", true);
        }
        event.getData().func_74782_a("CCM-Properties", (NBTBase)tag);
    }

    @ForgeSubscribe
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.world.field_73011_w.field_76574_g;
        if (this.dimensionBlacklist.contains(dim)) {
            return;
        }
        boolean bedrock = false;
        boolean ores = false;
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a("CCM-Properties");
        if (tag != null) {
            bedrock = !tag.func_74764_b("CCM-Bedrock") && Properties.retroFlatBedrock && Properties.genFlatBedrock;
            ores = !tag.func_74764_b("CCM-Ores") && Properties.retroOreGen;
        }
        ChunkCoord cCoord = new ChunkCoord(event.getChunk());
        if (tag == null && (Properties.retroFlatBedrock && Properties.genFlatBedrock || Properties.retroOreGen)) {
            regen = true;
        }
        if (bedrock) {
            LogHandler.log(NucleumOmnium.instance, (Object)("Regenerating flat bedrock for the chunk at " + cCoord.toString() + "."));
            regen = true;
        }
        if (ores) {
            LogHandler.log(NucleumOmnium.instance, (Object)("Regenerating ores for the chunk at " + cCoord.toString() + "."));
            regen = true;
        }
        if (regen) {
            ArrayList chunks = (ArrayList)TickHandlerWorld.chunksToGen.get(dim);
            if (chunks == null) {
                TickHandlerWorld.chunksToGen.put(dim, new ArrayList());
                chunks = (ArrayList)TickHandlerWorld.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.add(cCoord);
                TickHandlerWorld.chunksToGen.put(dim, chunks);
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    @Override
    public boolean registerFeature(IFeatureGenerator feature) {
        if (this.oreNames.contains(feature.getFeatureName())) {
            return false;
        }
        this.oreNames.add(feature.getFeatureName());
        this.ores.add(feature);
        return true;
    }

    public static boolean addOre(IFeatureGenerator Ore) {
        return instance.registerFeature(Ore);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        this.replaceBedrock(random, chunkX, chunkZ, world, newGen);
        if (!newGen && !Properties.retroOreGen) {
            return;
        }
        for (IFeatureGenerator feature : this.ores) {
            feature.generateFeature(random, chunkX, chunkZ, world, newGen);
        }
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    public void replaceBedrock(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!Properties.genFlatBedrock || !newGen && !Properties.retroFlatBedrock) {
            return;
        }
        boolean isNether = world.field_73011_w.field_76575_d;
        if (isNether) {
            this.replaceBR(chunkX, chunkZ, world, Block.field_72012_bb);
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    for (int blockY = 126; blockY > 121; --blockY) {
                        if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                        world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, Block.field_72012_bb.field_71990_ca, 0, 2);
                    }
                }
            }
        } else {
            this.replaceBR(chunkX, chunkZ, world, Block.field_71981_t);
        }
    }

    private void replaceBR(int chunkX, int chunkZ, World world, Block block) {
        for (int blockX = 0; blockX < 16; ++blockX) {
            for (int blockZ = 0; blockZ < 16; ++blockZ) {
                for (int blockY = 5; blockY > 0; --blockY) {
                    if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                    world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, block.field_71990_ca, 0, 2);
                }
            }
        }
    }
}

