/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_world;

import ccm.nucleum_omnium.configuration.AdvConfiguration;
import ccm.nucleum_world.NucleumWorld;
import ccm.nucleum_world.generator.WorldGenHandler;
import java.util.ArrayList;
import lib.cofh.api.world.WeightedRandomBlock;
import lib.cofh.util.StringHelper;
import lib.cofh.world.feature.FeatureOreGenUniform;
import lib.cofh.world.feature.WorldGenMinableCluster;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ConfigCategory;

public final class WorldGenerator {
    public static void addOverworldGen(String modName, ItemStack stack, String oreName, int clusterSize, int numClusters, int minY, int maxY, boolean enable) {
        WorldGenerator.addWorldGen(modName, stack, oreName, clusterSize, numClusters, minY, maxY, enable, Block.field_71981_t);
    }

    public static void addEndGen(String modName, ItemStack stack, String oreName, int clusterSize, int numClusters, int minY, int maxY, boolean enable) {
        WorldGenerator.addWorldGen(modName, stack, oreName, clusterSize, numClusters, minY, maxY, enable, Block.field_72082_bJ);
    }

    public static void addNetherGen(String modName, ItemStack stack, String oreName, int clusterSize, int numClusters, int minY, int maxY, boolean enable) {
        WorldGenerator.addWorldGen(modName, stack, oreName, clusterSize, numClusters, minY, maxY, enable, Block.field_72012_bb);
    }

    private static void addWorldGen(String modName, ItemStack stack, String oreName, int clusterSize, int numClusters, int minY, int maxY, boolean enable, Block blockToReplace) {
        modName = modName + "." + StringHelper.titleCase(oreName);
        AdvConfiguration config = NucleumWorld.instance.getConfigFile();
        ConfigCategory cat = config.getCategory(modName);
        clusterSize = config.get(modName, "ClusterSize", clusterSize).getInt();
        numClusters = config.get(modName, "NumClusters", numClusters).getInt();
        minY = config.get(modName, "MinHeight", minY).getInt();
        maxY = config.get(modName, "MaxHeight", maxY).getInt();
        boolean regen = config.get(modName, "RetroGen", enable).getBoolean(enable);
        cat.setComment("Configurations for " + StringHelper.titleCase(oreName));
        config.save();
        if (!enable) {
            return;
        }
        ArrayList<WeightedRandomBlock> resList = new ArrayList<WeightedRandomBlock>();
        resList.add(new WeightedRandomBlock(stack));
        WorldGenHandler.addOre(new FeatureOreGenUniform(oreName, new WorldGenMinableCluster(resList, clusterSize, blockToReplace.field_71990_ca), numClusters, minY, maxY, regen));
    }
}

