/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_omnium.tileentity.helpers;

import ccm.nucleum_omnium.handler.LogHandler;
import ccm.nucleum_omnium.tileentity.BaseTE;
import ccm.nucleum_omnium.tileentity.interfaces.ITileLogic;
import java.lang.reflect.Constructor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public final class BaseTEData {
    private ForgeDirection orientation = ForgeDirection.SOUTH;
    private String owner = "";
    private String customName = "";
    private boolean hasLogic = false;
    private Class srclogic = null;
    private ITileLogic logic = null;
    private final BaseTE tile;

    public BaseTEData(BaseTE tile) {
        this.tile = tile;
    }

    public String getCustomName() {
        return this.customName;
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public String getOwner() {
        return this.owner;
    }

    private void loadLogic() {
        if (this.srclogic != null) {
            Constructor c = null;
            String failConst = "Logic loader has failed to get the Constructor for: \n %s With error: \n %s";
            try {
                c = this.srclogic.getConstructor(TileEntity.class);
            }
            catch (Exception e) {
                LogHandler.log("Logic loader has failed to get the Constructor for: \n %s With error: \n %s", this.toString(), e.toString());
                if (e.getCause() != null) {
                    LogHandler.log((Object)"\nAnd Cause: %s", e.getCause());
                }
                e.printStackTrace();
            }
            String failInst = "Logic loader has failed to create a new Instance of: \n %s With error: \n %s";
            try {
                this.logic = (ITileLogic)c.newInstance(new Object[]{this.tile});
            }
            catch (Exception e) {
                LogHandler.log("Logic loader has failed to create a new Instance of: \n %s With error: \n %s", this.toString(), e.toString());
                if (e.getCause() != null) {
                    LogHandler.log((Object)"\nAnd Cause: %s", e.getCause());
                }
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("\nsrclogic WAS NULL!!!! \n");
        }
    }

    public ITileLogic getTileLogic() {
        if (this.logic == null) {
            this.loadLogic();
        }
        return this.logic;
    }

    public Class getSrcLogic() {
        return this.srclogic;
    }

    public boolean hasCustomName() {
        return this.customName != null && this.customName.length() > 0;
    }

    public boolean hasOwner() {
        return this.owner != null && this.owner.length() > 0;
    }

    public boolean hasLogic() {
        return this.hasLogic;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void setOrientation(ForgeDirection orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(int direction) {
        this.orientation = ForgeDirection.getOrientation((int)direction);
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setLogic(Class logic) {
        this.hasLogic = true;
        this.srclogic = logic;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        LogHandler.log("Writing: %s to NBT", new Object[]{this.tile});
        nbt.func_74774_a("CCM.TILE_ENTITY.DIRECTION", (byte)this.orientation.ordinal());
        if (this.hasOwner()) {
            nbt.func_74778_a("CCM.TILE_ENTITY.OWNER", this.owner);
        }
        if (this.hasCustomName()) {
            nbt.func_74778_a("CCM.TILE_ENTITY.NAME", this.customName);
        }
        if (this.hasLogic()) {
            if (this.srclogic != null) {
                nbt.func_74778_a("CCM.TILE_ENTITY.SRC_LOGIC", this.srclogic.getName());
            } else {
                LogHandler.log("%sSource Logic was null when tring to save to NBT!", new Object[]{this.tile});
            }
            if (this.logic != null) {
                this.logic.writeToNBT(nbt);
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        LogHandler.log("Reading: %s from NBT", new Object[]{this.tile});
        if (nbt.func_74764_b("CCM.TILE_ENTITY.DIRECTION")) {
            this.orientation = ForgeDirection.getOrientation((int)nbt.func_74771_c("CCM.TILE_ENTITY.DIRECTION"));
        }
        if (nbt.func_74764_b("CCM.TILE_ENTITY.OWNER")) {
            this.owner = nbt.func_74779_i("CCM.TILE_ENTITY.OWNER");
        }
        if (nbt.func_74764_b("CCM.TILE_ENTITY.NAME")) {
            this.customName = nbt.func_74779_i("CCM.TILE_ENTITY.NAME");
        }
        if (nbt.func_74764_b("CCM.TILE_ENTITY.SRC_LOGIC")) {
            String tmp = nbt.func_74779_i("CCM.TILE_ENTITY.SRC_LOGIC");
            LogHandler.log(tmp);
            try {
                this.srclogic = Class.forName(tmp);
            }
            catch (ClassNotFoundException e) {
                String failNBT = "Logic loader has failed to find a class named: \n %s With error: \n %s";
                LogHandler.log("Logic loader has failed to find a class named: \n %s With error: \n %s", tmp, e.toString());
                e.printStackTrace();
            }
        }
        if (this.hasLogic() && this.logic != null) {
            this.logic.readFromNBT(nbt);
        }
    }

    public BaseTEData clone() {
        BaseTEData tmp = new BaseTEData(this.tile);
        tmp.setCustomName(this.getCustomName());
        tmp.setLogic(this.getSrcLogic());
        tmp.setOrientation(this.getOrientation());
        tmp.setOwner(this.getOwner());
        return tmp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customName == null ? 0 : this.customName.hashCode());
        result = 31 * result + (this.hasLogic ? 1231 : 1237);
        result = 31 * result + (this.logic == null ? 0 : this.logic.hashCode());
        result = 31 * result + (this.orientation == null ? 0 : this.orientation.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.srclogic == null ? 0 : this.srclogic.hashCode());
        result = 31 * result + (this.tile == null ? 0 : ((Object)((Object)this.tile)).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseTEData)) {
            return false;
        }
        BaseTEData other = (BaseTEData)obj;
        if (this.customName == null ? other.customName != null : !this.customName.equals(other.customName)) {
            return false;
        }
        if (this.hasLogic != other.hasLogic) {
            return false;
        }
        if (this.logic == null ? other.logic != null : !this.logic.equals(other.logic)) {
            return false;
        }
        if (this.orientation != other.orientation) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.srclogic == null ? other.srclogic != null : !this.srclogic.equals(other.srclogic)) {
            return false;
        }
        return !(this.tile == null ? other.tile != null : !((Object)((Object)this.tile)).equals((Object)other.tile));
    }
}

