/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_omnium.helper;

import ccm.nucleum_omnium.base.BaseNIC;
import java.io.File;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;

public final class DataHelper
extends BaseNIC {
    private static File root;

    public static void init() {
        root = new File(DimensionManager.getCurrentSaveRootDirectory(), "CCM-Modding");
        root.mkdirs();
    }

    public static File getModFolder(String modID) {
        File folder = new File(root, modID);
        folder.mkdirs();
        return folder;
    }

    public static boolean saveData(String modID, String fileName, NBTTagCompound data) {
        try {
            File folder = DataHelper.getModFolder(modID);
            File tempFile = new File(folder, fileName.trim() + "_tmp.dat");
            File realFile = new File(folder, fileName.trim() + ".dat");
            CompressedStreamTools.func_74795_b((NBTTagCompound)data, (File)tempFile);
            if (realFile.exists()) {
                realFile.delete();
            }
            tempFile.renameTo(realFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static NBTTagCompound readData(String modID, String fileName) {
        try {
            File folder = DataHelper.getModFolder(modID);
            File file = new File(folder, fileName.trim() + ".dat");
            if (!file.exists()) {
                return new NBTTagCompound();
            }
            return CompressedStreamTools.func_74797_a((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new NBTTagCompound();
        }
    }

    public static boolean deleteFile(String modID, String fileName) {
        try {
            File folder = DataHelper.getModFolder(modID);
            File file = new File(folder, fileName.trim() + ".dat");
            return file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

