/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_omnium.handler;

import ccm.nucleum_omnium.IMod;
import ccm.nucleum_omnium.base.BaseNIC;
import ccm.nucleum_omnium.utils.exeptions.DupeExeption;
import ccm.nucleum_omnium.utils.exeptions.LNFExeption;
import ccm.nucleum_omnium.utils.lib.Properties;
import cpw.mods.fml.common.FMLLog;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogHandler
extends BaseNIC {
    private static final HashMap modsLogged = new HashMap();

    public static void initLog(IMod mod) {
        if (modsLogged.containsKey(mod)) {
            throw new DupeExeption(mod);
        }
        Logger tmp = Logger.getLogger(mod.getModId());
        tmp.setParent(FMLLog.getLogger());
        modsLogged.put(mod, tmp);
    }

    public static void log(Object msg) {
        if (Properties.debug) {
            System.err.println(msg);
        }
    }

    public static void log(String msg, Object ... args) {
        if (Properties.debug) {
            System.err.println(String.format(msg, args));
        }
    }

    public static void log(Object msg, Throwable t) {
        LogHandler.log(msg + " \n" + t.toString());
    }

    public static void log(IMod mod, Object msg) {
        if (!modsLogged.containsKey(mod)) {
            throw new LNFExeption(mod);
        }
        ((Logger)modsLogged.get(mod)).log(Level.INFO, msg.toString());
    }

    public static void log(IMod mod, Object msg, Throwable t) {
        if (!modsLogged.containsKey(mod)) {
            throw new LNFExeption(mod);
        }
        ((Logger)modsLogged.get(mod)).log(Level.INFO, msg.toString(), t);
    }

    public static void log(IMod mod, Level logLevel, Object msg) {
        if (!modsLogged.containsKey(mod)) {
            throw new LNFExeption(mod);
        }
        ((Logger)modsLogged.get(mod)).log(logLevel, msg.toString());
    }

    public static void log(IMod mod, Level logLevel, Object msg, Throwable t) {
        if (!modsLogged.containsKey(mod)) {
            throw new LNFExeption(mod);
        }
        ((Logger)modsLogged.get(mod)).log(logLevel, msg.toString(), t);
    }
}

