/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_omnium.command;

import ccm.nucleum_omnium.NucleumOmnium;
import ccm.nucleum_omnium.helper.JavaHelper;
import java.text.DecimalFormat;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandTPS
extends CommandBase {
    public static CommandTPS instance = new CommandTPS();
    private static DecimalFormat floatfmt = new DecimalFormat("##0.00");

    private double getTickTimeSum(long[] times) {
        long timesum = 0L;
        if (times == null) {
            return 0.0;
        }
        for (long time : times) {
            timesum += time;
        }
        return timesum / (long)times.length;
    }

    private double getTickMs(World world) {
        return this.getTickTimeSum(world == null ? NucleumOmnium.server.field_71311_j : (long[])NucleumOmnium.server.worldTickTimes.get(world.field_73011_w.field_76574_g)) * 1.0E-6;
    }

    private double getTps(World world) {
        double tps = 1000.0 / this.getTickMs(world);
        return tps > 20.0 ? 20.0 : tps;
    }

    public String func_71517_b() {
        return "tps";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 1) {
            double tps = this.getTps(null);
            double tickms = this.getTickMs(null);
            sender.func_70006_a("--------------------------------------------------");
            sender.func_70006_a("Overall: " + floatfmt.format(tps) + " TPS/" + floatfmt.format(tickms) + "MS (" + (int)(tps / 20.0 * 100.0) + "%)");
            sender.func_70006_a("");
            for (WorldServer world : NucleumOmnium.server.field_71305_c) {
                tps = this.getTps((World)world);
                tickms = this.getTickMs((World)world);
                sender.func_70006_a(world.field_73011_w.func_80007_l() + " [" + world.field_73011_w.field_76574_g + "]: " + floatfmt.format(tps) + " TPS/" + floatfmt.format(tickms) + "MS (" + (int)(tps / 20.0 * 100.0) + "%)");
            }
            sender.func_70006_a("--------------------------------------------------");
        } else if (args[0].toLowerCase().charAt(0) == 'o') {
            double tickms = this.getTickMs(null);
            double tps = this.getTps(null);
            sender.func_70006_a("--------------------------------------------------");
            sender.func_70006_a("Overall server tick:");
            sender.func_70006_a("TPS: " + floatfmt.format(tps) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%)");
            sender.func_70006_a("Tick time: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms");
            sender.func_70006_a("--------------------------------------------------");
        } else if (args[0].toLowerCase().charAt(0) == 'a') {
            double tickms = this.getTickMs(null);
            double tps = this.getTps(null);
            sender.func_70006_a("--------------------------------------------------");
            sender.func_70006_a("Overall server tick:");
            sender.func_70006_a("TPS: " + floatfmt.format(tps) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%)");
            sender.func_70006_a("Tick time: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms");
            sender.func_70006_a("");
            int loadedChunks = 0;
            int entities = 0;
            int te = 0;
            int worlds = 0;
            for (WorldServer world : NucleumOmnium.server.field_71305_c) {
                loadedChunks += world.func_72863_F().func_73152_e();
                entities += world.field_72996_f.size();
                te += world.field_73009_h.size();
                ++worlds;
            }
            sender.func_70006_a("Total Loaded Worlds/Chunks: " + worlds + "/" + loadedChunks);
            sender.func_70006_a("");
            sender.func_70006_a("Total Entities/TileEntities: " + entities + "/" + te);
            sender.func_70006_a("--------------------------------------------------");
        } else if (JavaHelper.isNumeric(args[0])) {
            int dim = Integer.parseInt(args[0]);
            WorldServer world = NucleumOmnium.server.func_71218_a(dim);
            if (world == null) {
                throw new PlayerNotFoundException("World not found", new Object[0]);
            }
            double tickms = this.getTickMs((World)world);
            double tps = this.getTps((World)world);
            sender.func_70006_a("--------------------------------------------------");
            sender.func_70006_a(world.field_73011_w.func_80007_l() + " [" + world.field_73011_w.field_76574_g + "]");
            sender.func_70006_a("Loaded chunks: " + world.func_72863_F().func_73152_e());
            sender.func_70006_a("");
            sender.func_70006_a("TPS: " + floatfmt.format(tps) + "/" + floatfmt.format(20L) + " TPS (" + (int)(tps / 20.0 * 100.0) + "%)");
            sender.func_70006_a("Tick: " + floatfmt.format(tickms) + " ms of " + floatfmt.format(50L) + " ms");
            sender.func_70006_a("");
            sender.func_70006_a("Entities: " + world.field_72996_f.size());
            sender.func_70006_a("Tile entities: " + world.field_73009_h.size());
            sender.func_70006_a("--------------------------------------------------");
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }
}

