/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_omnium.block.sub;

import ccm.nucleum_omnium.block.ICollisionListener;
import ccm.nucleum_omnium.block.IDisplayListener;
import ccm.nucleum_omnium.block.MainBlock;
import ccm.nucleum_omnium.handler.LogHandler;
import ccm.nucleum_omnium.helper.TextureHelper;
import ccm.nucleum_omnium.helper.enums.IBlockEnum;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SubBlock {
    private MainBlock mainBlock;
    private CreativeTabs tab;
    private final int meta;
    private ItemStack drop;
    private int dropMin;
    private int dropMax;
    private float hardness;
    private float blockResistance;
    private boolean collisionEffect;
    private String unlocName;
    public List displayList = new ArrayList();
    public List collisionList = new ArrayList();
    public Icon icon;
    public String iconName;

    public SubBlock(int id, int meta, String iconName) {
        if (Block.field_71973_m[id] == null) {
            this.mainBlock = new MainBlock(id);
            this.mainBlock.addSubBlock(this, meta);
        } else {
            this.mainBlock = (MainBlock)Block.field_71973_m[id];
            this.mainBlock.addSubBlock(this, meta);
        }
        this.meta = meta;
        this.iconName = iconName;
    }

    public SubBlock(int id, int meta, Material material, String iconName) {
        if (Block.field_71973_m[id] == null) {
            this.mainBlock = new MainBlock(id, material);
            this.mainBlock.addSubBlock(this, meta);
        } else {
            this.mainBlock = (MainBlock)Block.field_71973_m[id];
            this.mainBlock.addSubBlock(this, meta);
        }
        this.meta = meta;
        this.iconName = iconName;
    }

    public void addDisplayListener(IDisplayListener displayL) {
        this.mainBlock.setTickRandomly(this.meta);
        this.displayList.add(displayL);
    }

    public void addCollisionListener(ICollisionListener collisionL) {
        this.collisionEffect = true;
        this.collisionList.add(collisionL);
    }

    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        for (IDisplayListener dl : this.displayList) {
            dl.randomDisplayTick(world, x, y, z, rand);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (this.collisionEffect) {
            float var5 = 0.025f;
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + 1.0f - 0.025f), (double)(z + 1));
        }
        return null;
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity par5Entity) {
        for (ICollisionListener cl : this.collisionList) {
            cl.collide(world, x, y, z, par5Entity, this.meta);
        }
    }

    public SubBlock setCreativeTab(CreativeTabs tab) {
        this.mainBlock.func_71849_a(tab);
        this.tab = tab;
        return this;
    }

    public SubBlock setUnlocalizedName(String string) {
        this.unlocName = string + ".name";
        this.mainBlock.func_71864_b(this.unlocName);
        return this;
    }

    public SubBlock setUnlocalizedName(Enum enu) {
        return this.setUnlocalizedName(enu.name());
    }

    public SubBlock setBlockDrops(ItemStack item, int min, int max) {
        this.drop = item.func_77946_l();
        this.dropMin = min;
        this.dropMax = max;
        return this;
    }

    public SubBlock setHardness(float hardness) {
        this.hardness = hardness;
        if (this.blockResistance < hardness * 5.0f) {
            this.blockResistance = hardness * 5.0f;
        }
        return this;
    }

    public SubBlock setResistance(float ressistance) {
        this.blockResistance = ressistance * 3.0f;
        return this;
    }

    public SubBlock setSlipperiness(float slipperiness) {
        this.mainBlock.field_72016_cq = slipperiness;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTexture(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.getIcon(side, blockAccess.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(int side, int meta) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a(this.iconName);
    }

    public Icon getBlockTextureFromSide(int side) {
        return this.icon;
    }

    public CreativeTabs getCreativeTab() {
        return this.tab;
    }

    public String getUnlocalizedName() {
        return this.unlocName;
    }

    public Block getBlock() {
        return this.mainBlock;
    }

    public int quantityDroppedWithBonus(int fortune, Random rand) {
        if (this.drop != null && this.dropMax > 1) {
            return this.dropMin + rand.nextInt(this.dropMax + fortune) + fortune;
        }
        return 1;
    }

    public int idDropped(Random rand, int par3) {
        if (this.drop != null) {
            return this.drop.field_77993_c;
        }
        return this.mainBlock.field_71990_ca;
    }

    public float getBlockHardness() {
        return this.hardness;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return this.blockResistance / 5.0f;
    }

    public int damageDropped(int meta) {
        if (this.idDropped(new Random(), meta) == this.mainBlock.field_71990_ca) {
            return meta;
        }
        return 0;
    }

    public int getDamageValue(World world, int x, int y, int z) {
        return this.meta;
    }

    public boolean hasTileEntity(int meta) {
        return false;
    }

    public TileEntity createTileEntity(World world, int meta) {
        LogHandler.log("Using Default createTileEntity");
        return null;
    }

    public void breakBlock(World world, int x, int y, int z, int id, int meta) {
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int wut, float clickX, float clickY, float clockZ) {
        return false;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLiving living, ItemStack itemStack) {
    }

    public String toString() {
        return super.toString() + this.mainBlock.func_71917_a();
    }

    public static SubBlock setUp(Enum blockEnum, SubBlock instance) {
        MainBlock block = (MainBlock)instance.getBlock();
        ((IBlockEnum)((Object)blockEnum)).setBaseBlock(block);
        MainBlock.registerID(block.field_71990_ca);
        return instance;
    }

    public static SubBlock createAndSetUp(Enum blockEnum, int id, String textureLoc) {
        return SubBlock.setUp(blockEnum, new SubBlock(id, blockEnum.ordinal(), TextureHelper.getTextureFromName(blockEnum.name(), textureLoc)).setUnlocalizedName(blockEnum));
    }
}

