/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_omnium.block.sub;

import ccm.nucleum_omnium.block.sub.SBMutlyTexture;
import ccm.nucleum_omnium.handler.GUIHandler;
import ccm.nucleum_omnium.handler.LogHandler;
import ccm.nucleum_omnium.helper.BlockHelper;
import ccm.nucleum_omnium.helper.FunctionHelper;
import ccm.nucleum_omnium.tileentity.BaseTE;
import ccm.nucleum_omnium.tileentity.InventoryTE;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class SBWithTile
extends SBMutlyTexture {
    private Class te = null;
    private Class logic = null;
    private boolean hasTE = false;
    private boolean hasInv = false;
    private int size;

    public SBWithTile(int id, int meta, String iconName, List goodSides) {
        super(id, meta, iconName, goodSides);
    }

    public SBWithTile(int id, int meta, Material material, String iconName, List goodSides) {
        super(id, meta, material, iconName, goodSides);
    }

    public SBWithTile setTileEntity(TileEntity te) {
        if (te != null) {
            this.te = te.getClass();
            if (te instanceof BaseTE) {
                if (((BaseTE)te).hasLogic()) {
                    this.logic = ((BaseTE)te).getSrcLogic();
                    LogHandler.log("Block: %s Tile has Logic \n", this.iconName);
                }
                if (te instanceof InventoryTE) {
                    this.hasInv = true;
                    this.size = ((InventoryTE)te).func_70302_i_();
                    LogHandler.log("Block: %s Tile is an InventoryTE \n", this.iconName);
                }
            }
            this.hasTE = true;
        } else {
            LogHandler.log("te was Null!! @ setTileEntity \n");
        }
        return this;
    }

    @Override
    public boolean hasTileEntity(int meta) {
        return this.hasTE;
    }

    public boolean hasInventory() {
        return this.hasInv;
    }

    @Override
    public TileEntity createTileEntity(World world, int meta) {
        if (this.logic != null) {
            try {
                LogHandler.log("Creating TE: %s \nWith Logic: %s \n", this.te, this.logic);
                if (this.hasInventory()) {
                    return ((InventoryTE)((BaseTE)((Object)this.te.newInstance())).setLogic(this.logic)).setInventorySize(this.size);
                }
                return ((BaseTE)((Object)this.te.newInstance())).setLogic(this.logic);
            }
            catch (Exception e) {
                LogHandler.log("TileEntity Instance with logic could not be created during createTileEntity \n");
                e.getCause();
                e.printStackTrace();
                return null;
            }
        }
        try {
            LogHandler.log("Creating TE: %s \n", this.te);
            if (this.hasInventory()) {
                return ((InventoryTE)((Object)this.te.newInstance())).setInventorySize(this.size);
            }
            return (TileEntity)this.te.newInstance();
        }
        catch (Exception e) {
            LogHandler.log("TileEntity Instance could not be created during createTileEntity \n");
            e.getCause();
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int wut, float clickX, float clickY, float clockZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        BaseTE te = (BaseTE)world.func_72796_p(x, y, z);
        if (te != null) {
            LogHandler.log((Object)te);
            LogHandler.log(player.func_70023_ak());
            LogHandler.log(x);
            LogHandler.log(y);
            LogHandler.log(z);
            LogHandler.log(FunctionHelper.getTEName(world, x, y, z));
            LogHandler.log(this.getUnlocalizedName());
            GUIHandler.openGui(FunctionHelper.getTEName(world, x, y, z), player, world, x, y, z);
            return true;
        }
        LogHandler.log("TileEntity at %s, %s, %s, was null", x, y, z);
        return false;
    }

    @Override
    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLiving living, ItemStack itemStack) {
        BaseTE te = (BaseTE)world.func_72796_p(x, y, z);
        int direction = 0;
        int facing = MathHelper.func_76128_c((double)((double)(living.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (facing == 0) {
            direction = ForgeDirection.NORTH.ordinal();
        } else if (facing == 1) {
            direction = ForgeDirection.EAST.ordinal();
        } else if (facing == 2) {
            direction = ForgeDirection.SOUTH.ordinal();
        } else if (facing == 3) {
            direction = ForgeDirection.WEST.ordinal();
        }
        BlockHelper.updateAdjacent(world, x, y, z, 3);
        if (itemStack.func_82837_s()) {
            te.setCustomName(itemStack.func_82833_r());
        }
        te.setOrientation(direction);
    }
}

