/*
 * Decompiled with CFR 0.152.
 */
package ccm.nucleum_omnium.block;

import ccm.nucleum_omnium.block.sub.SubBlock;
import ccm.nucleum_omnium.helper.FunctionHelper;
import ccm.nucleum_omnium.item.block.MainItemBlock;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MainBlock
extends Block {
    SubBlock[] subBlocks = new SubBlock[16];
    List tickList = new ArrayList();
    ArrayList tabs;
    public static List registeredIDs;

    public static void registerID(int id) {
        if (registeredIDs == null) {
            registeredIDs = new ArrayList();
        }
        if (registeredIDs.contains(id)) {
            return;
        }
        Block block = Block.field_71973_m[id];
        if (block instanceof MainBlock) {
            GameRegistry.registerBlock((Block)block, MainItemBlock.class, (String)block.func_71917_a());
            registeredIDs.add(id);
        }
    }

    public MainBlock(int id) {
        super(id, Material.field_76246_e);
    }

    public MainBlock(int id, Material material) {
        super(id, material);
    }

    public void addSubBlock(SubBlock block, int meta) {
        if (this.subBlocks[meta] != null) {
            throw new IllegalArgumentException("Block " + this.field_71990_ca + " " + (Object)((Object)this) + " metadata " + meta + " is already occupied by " + this.subBlocks[meta] + " when adding " + block);
        }
        this.subBlocks[meta] = block;
    }

    public int func_71899_b(int meta) {
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].damageDropped(meta);
        }
        return meta;
    }

    public SubBlock[] getSubBlocks() {
        return this.subBlocks;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int meta, CreativeTabs creativeTab, List list) {
        for (int n = 0; n < 16; ++n) {
            if (this.subBlocks[n] == null || creativeTab != this.subBlocks[n].getCreativeTab()) continue;
            list.add(new ItemStack((Block)this, 1, n));
        }
    }

    public void setTickRandomly(int meta) {
        if (!this.tickList.contains(meta)) {
            this.func_71907_b(true);
            this.tickList.add(meta);
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        AxisAlignedBB ret = null;
        if (this.subBlocks[meta] != null) {
            ret = this.subBlocks[meta].getCollisionBoundingBoxFromPool(world, x, y, z);
        }
        if (ret != null) {
            return ret;
        }
        return super.func_71872_e(world, x, y, z);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            this.subBlocks[meta].onEntityCollidedWithBlock(world, x, y, z, entity);
        }
    }

    public void func_71862_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            this.subBlocks[meta].randomDisplayTick(world, x, y, z, rand);
        } else {
            super.func_71862_a(world, x, y, z, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].getIcon(side, meta);
        }
        return super.func_71858_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int meta = blockAccess.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].getBlockTexture(blockAccess, x, y, z, side);
        }
        return super.func_71895_b(blockAccess, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        for (int i = 0; i < 16; ++i) {
            if (this.subBlocks[i] == null) continue;
            this.subBlocks[i].registerIcons(iconRegister);
        }
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            int id = this.func_71885_a(metadata, world.field_73012_v, fortune);
            if (id <= 0) continue;
            ret.add(new ItemStack(id, 1, this.func_71899_b(metadata)));
        }
        return ret;
    }

    public int quantityDropped(int meta, int fortune, Random rand) {
        return this.subBlocks[meta].quantityDroppedWithBonus(fortune, rand);
    }

    public int func_71885_a(int meta, Random rand, int par3) {
        return this.subBlocks[meta].idDropped(rand, par3);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].getBlockHardness();
        }
        return 0.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
        }
        return 0.0f;
    }

    public int func_71873_h(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            System.out.println("returning " + this.subBlocks[meta].getDamageValue(world, x, y, z));
            return this.subBlocks[meta].getDamageValue(world, x, y, z);
        }
        return meta;
    }

    public Block func_71849_a(CreativeTabs par1CreativeTabs) {
        if (this.tabs == null) {
            this.tabs = new ArrayList();
        }
        if (!this.tabs.contains(par1CreativeTabs)) {
            this.tabs.add(par1CreativeTabs);
        }
        return this;
    }

    public CreativeTabs[] getCreativeTabArray() {
        if (this.tabs == null) {
            return new CreativeTabs[0];
        }
        return this.tabs.toArray(new CreativeTabs[this.tabs.size()]);
    }

    public boolean hasTileEntity(int meta) {
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].hasTileEntity(meta);
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int meta) {
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].createTileEntity(world, meta);
        }
        return null;
    }

    public void func_71852_a(World world, int x, int y, int z, int id, int meta) {
        FunctionHelper.dropInventory(world, x, y, z);
        if (this.subBlocks[meta] != null) {
            this.subBlocks[meta].breakBlock(world, x, y, z, id, meta);
        }
        super.func_71852_a(world, x, y, z, id, meta);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int wut, float clickX, float clickY, float clockZ) {
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            return this.subBlocks[meta].onBlockActivated(world, x, y, z, player, wut, clickX, clickY, clockZ);
        }
        return false;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        super.func_71861_g(world, x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            this.subBlocks[meta].onBlockAdded(world, x, y, z);
        }
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving living, ItemStack itemStack) {
        int meta = world.func_72805_g(x, y, z);
        if (this.subBlocks[meta] != null) {
            this.subBlocks[meta].onBlockPlacedBy(world, x, y, z, living, itemStack);
        }
    }
}

