/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidRegistry {
    static int maxID = 0;
    static HashMap fluids = new HashMap();
    static BiMap fluidIDs = HashBiMap.create();
    public static final Fluid WATER = new Fluid("water").setBlockID(Block.field_71943_B.field_71990_ca);
    public static final Fluid LAVA = new Fluid("lava").setBlockID(Block.field_71938_D.field_71990_ca).setLuminosity(15).setDensity(3000).setViscosity(6000);
    public static int renderIdFluid = -1;

    private FluidRegistry() {
    }

    static void initFluidIDs(BiMap newfluidIDs) {
        maxID = newfluidIDs.size();
        fluidIDs.clear();
        fluidIDs.putAll((Map)newfluidIDs);
    }

    public static boolean registerFluid(Fluid fluid) {
        if (fluidIDs.containsKey((Object)fluid.getName())) {
            return false;
        }
        fluids.put(fluid.getName(), fluid);
        fluidIDs.put((Object)fluid.getName(), (Object)(++maxID));
        MinecraftForge.EVENT_BUS.post((Event)new FluidRegisterEvent(fluid.getName(), maxID));
        return true;
    }

    public static boolean isFluidRegistered(Fluid fluid) {
        return fluidIDs.containsKey((Object)fluid.getName());
    }

    public static boolean isFluidRegistered(String fluidName) {
        return fluidIDs.containsKey((Object)fluidName);
    }

    public static Fluid getFluid(String fluidName) {
        return (Fluid)fluids.get(fluidName);
    }

    public static Fluid getFluid(int fluidID) {
        return (Fluid)fluids.get(FluidRegistry.getFluidName(fluidID));
    }

    public static String getFluidName(int fluidID) {
        return (String)fluidIDs.inverse().get((Object)fluidID);
    }

    public static String getFluidName(FluidStack stack) {
        return FluidRegistry.getFluidName(stack.fluidID);
    }

    public static int getFluidID(String fluidName) {
        return (Integer)fluidIDs.get((Object)fluidName);
    }

    public static FluidStack getFluidStack(String fluidName, int amount) {
        if (!fluidIDs.containsKey((Object)fluidName)) {
            return null;
        }
        return new FluidStack(FluidRegistry.getFluidID(fluidName), amount);
    }

    public static Map getRegisteredFluids() {
        return ImmutableMap.copyOf((Map)fluids);
    }

    public static Map getRegisteredFluidIDs() {
        return ImmutableMap.copyOf((Map)fluidIDs);
    }

    static {
        FluidRegistry.registerFluid(WATER);
        FluidRegistry.registerFluid(LAVA);
    }

    public static class FluidRegisterEvent
    extends Event {
        public final String fluidName;
        public final int fluidID;

        public FluidRegisterEvent(String fluidName, int fluidID) {
            this.fluidName = fluidName;
            this.fluidID = fluidID;
        }
    }
}

