/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidContainerRegistry {
    private static Map containerFluidMap = new HashMap();
    private static Map filledContainerMap = new HashMap();
    private static Set emptyContainers = new HashSet();
    public static final int BUCKET_VOLUME = 1000;
    public static final ItemStack EMPTY_BUCKET = new ItemStack(Item.field_77788_aw);
    public static final ItemStack EMPTY_BOTTLE = new ItemStack(Item.field_77729_bt);

    private FluidContainerRegistry() {
    }

    public static boolean registerFluidContainer(FluidStack stack, ItemStack filledContainer, ItemStack emptyContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, emptyContainer));
    }

    public static boolean registerFluidContainer(Fluid fluid, ItemStack filledContainer, ItemStack emptyContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer, emptyContainer);
    }

    public static boolean registerFluidContainer(FluidStack stack, ItemStack filledContainer) {
        return FluidContainerRegistry.registerFluidContainer(new FluidContainerData(stack, filledContainer, null, true));
    }

    public static boolean registerFluidContainer(Fluid fluid, ItemStack filledContainer) {
        if (!FluidRegistry.isFluidRegistered(fluid)) {
            FluidRegistry.registerFluid(fluid);
        }
        return FluidContainerRegistry.registerFluidContainer(new FluidStack(fluid, 1000), filledContainer);
    }

    public static boolean registerFluidContainer(FluidContainerData data) {
        if (FluidContainerRegistry.isFilledContainer(data.filledContainer)) {
            return false;
        }
        containerFluidMap.put(Arrays.asList(data.filledContainer.field_77993_c, data.filledContainer.func_77960_j()), data);
        if (data.emptyContainer != null) {
            filledContainerMap.put(Arrays.asList(data.emptyContainer.field_77993_c, data.emptyContainer.func_77960_j(), data.fluid.fluidID), data);
            emptyContainers.add(Arrays.asList(data.emptyContainer.field_77993_c, data.emptyContainer.func_77960_j()));
        }
        MinecraftForge.EVENT_BUS.post((Event)new FluidContainerRegisterEvent(data));
        return true;
    }

    public static FluidStack getFluidForFilledItem(ItemStack container) {
        if (container == null) {
            return null;
        }
        FluidContainerData data = (FluidContainerData)containerFluidMap.get(Arrays.asList(container.field_77993_c, container.func_77960_j()));
        return data == null ? null : data.fluid.copy();
    }

    public static ItemStack fillFluidContainer(FluidStack fluid, ItemStack container) {
        if (container == null || fluid == null) {
            return null;
        }
        FluidContainerData data = (FluidContainerData)filledContainerMap.get(Arrays.asList(container.field_77993_c, container.func_77960_j(), fluid.fluidID));
        if (data != null && fluid.amount >= data.fluid.amount) {
            return data.filledContainer.func_77946_l();
        }
        return null;
    }

    public static boolean containsFluid(ItemStack container, FluidStack fluid) {
        if (container == null || fluid == null) {
            return false;
        }
        FluidContainerData data = (FluidContainerData)filledContainerMap.get(Arrays.asList(container.field_77993_c, container.func_77960_j(), fluid.fluidID));
        return data == null ? false : data.fluid.isFluidEqual(fluid);
    }

    public static boolean isBucket(ItemStack container) {
        if (container == null) {
            return false;
        }
        if (container.func_77969_a(EMPTY_BUCKET)) {
            return true;
        }
        FluidContainerData data = (FluidContainerData)containerFluidMap.get(Arrays.asList(container.field_77993_c, container.func_77960_j()));
        return data != null && data.emptyContainer.func_77969_a(EMPTY_BUCKET);
    }

    public static boolean isContainer(ItemStack container) {
        return FluidContainerRegistry.isEmptyContainer(container) || FluidContainerRegistry.isFilledContainer(container);
    }

    public static boolean isEmptyContainer(ItemStack container) {
        return container != null && emptyContainers.contains(Arrays.asList(container.field_77993_c, container.func_77960_j()));
    }

    public static boolean isFilledContainer(ItemStack container) {
        return container != null && FluidContainerRegistry.getFluidForFilledItem(container) != null;
    }

    public static FluidContainerData[] getRegisteredFluidContainerData() {
        return (FluidContainerData[])containerFluidMap.values().toArray();
    }

    static {
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new ItemStack(Item.field_77786_ax), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.LAVA, new ItemStack(Item.field_77775_ay), EMPTY_BUCKET);
        FluidContainerRegistry.registerFluidContainer(FluidRegistry.WATER, new ItemStack((Item)Item.field_77726_bs), EMPTY_BOTTLE);
    }

    public static class FluidContainerRegisterEvent
    extends Event {
        public final FluidContainerData data;

        public FluidContainerRegisterEvent(FluidContainerData data) {
            this.data = data.copy();
        }
    }

    public static class FluidContainerData {
        public final FluidStack fluid;
        public final ItemStack filledContainer;
        public final ItemStack emptyContainer;

        public FluidContainerData(FluidStack stack, ItemStack filledContainer, ItemStack emptyContainer) {
            this(stack, filledContainer, emptyContainer, false);
        }

        public FluidContainerData(FluidStack stack, ItemStack filledContainer, ItemStack emptyContainer, boolean nullEmpty) {
            this.fluid = stack;
            this.filledContainer = filledContainer;
            this.emptyContainer = emptyContainer;
            if (stack == null || filledContainer == null || emptyContainer == null && !nullEmpty) {
                throw new RuntimeException("Invalid FluidContainerData - a parameter was null.");
            }
        }

        public FluidContainerData copy() {
            return new FluidContainerData(this.fluid, this.filledContainer, this.emptyContainer, true);
        }
    }
}

