/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Fluid {
    protected final String fluidName;
    protected String unlocalizedName;
    @SideOnly(value=Side.CLIENT)
    protected Icon stillIcon;
    @SideOnly(value=Side.CLIENT)
    protected Icon flowingIcon;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected int blockID = -1;

    public Fluid(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlockID(int blockID) {
        if (this.blockID != -1 && this.blockID != blockID) {
            FMLLog.severe((String)("A mod has attempted to assign BlockID " + blockID + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.blockID + ". Configure your mods to prevent this from happening."), (Object[])new Object[0]);
            throw new LoaderException((Throwable)new RuntimeException("A mod has attempted to assign BlockID " + blockID + " to the Fluid '" + this.fluidName + "' but this Fluid has already been linked to BlockID " + this.blockID + ". Configure your mods to prevent this from happening."));
        }
        this.blockID = blockID;
        return this;
    }

    public Fluid setBlockID(Block block) {
        return this.setBlockID(block.field_71990_ca);
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final int getID() {
        return FluidRegistry.getFluidID(this.fluidName);
    }

    public final int getBlockID() {
        return this.blockID;
    }

    public final boolean canBePlacedInWorld() {
        return this.blockID != -1;
    }

    public String getLocalizedName() {
        String s = this.getUnlocalizedName();
        return s == null ? "" : StatCollector.func_74838_a((String)s);
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getSpriteNumber() {
        return 0;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public int getColor() {
        return 0xFFFFFF;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public int getLuminosity(World world, int x, int y, int z) {
        return this.getLuminosity();
    }

    public int getDensity(World world, int x, int y, int z) {
        return this.getDensity();
    }

    public int getViscosity(World world, int x, int y, int z) {
        return this.getViscosity();
    }

    public boolean isGaseous(World world, int x, int y, int z) {
        return this.isGaseous();
    }

    public int getColor(World world, int x, int y, int z) {
        return this.getColor();
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setStillIcon(Icon stillIcon) {
        this.stillIcon = stillIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setFlowingIcon(Icon flowingIcon) {
        this.flowingIcon = flowingIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setIcons(Icon stillIcon, Icon flowingIcon) {
        this.stillIcon = stillIcon;
        this.flowingIcon = flowingIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public final Fluid setIcons(Icon commonIcon) {
        this.stillIcon = commonIcon;
        this.flowingIcon = commonIcon;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return this.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(FluidStack stack) {
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(World world, int x, int y, int z) {
        return this.getIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getStillIcon() {
        return this.stillIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getFlowingIcon() {
        return this.flowingIcon;
    }
}

