/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.world;

import biomesoplenty.api.Biomes;
import biomesoplenty.world.layer.BiomeLayer;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public class WorldChunkManagerBOP
extends WorldChunkManager {
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private List biomesToSpawnIn = new ArrayList();

    protected WorldChunkManagerBOP() {
        this.biomesToSpawnIn.add(BiomeGenBase.field_76767_f);
        this.biomesToSpawnIn.add(BiomeGenBase.field_76772_c);
        this.biomesToSpawnIn.add(BiomeGenBase.field_76768_g);
        this.biomesToSpawnIn.add(BiomeGenBase.field_76784_u);
        this.biomesToSpawnIn.add(BiomeGenBase.field_76785_t);
        this.biomesToSpawnIn.add(BiomeGenBase.field_76782_w);
        this.biomesToSpawnIn.add(BiomeGenBase.field_76792_x);
        this.addSpawnBiomes(Biomes.alps);
        this.addSpawnBiomes(Biomes.arctic);
        this.addSpawnBiomes(Biomes.badlands);
        this.addSpawnBiomes(Biomes.bambooForest);
        this.addSpawnBiomes(Biomes.bayou);
        this.addSpawnBiomes(Biomes.birchForest);
        this.addSpawnBiomes(Biomes.bog);
        this.addSpawnBiomes(Biomes.borealForest);
        this.addSpawnBiomes(Biomes.brushland);
        this.addSpawnBiomes(Biomes.chaparral);
        this.addSpawnBiomes(Biomes.cherryBlossomGrove);
        this.addSpawnBiomes(Biomes.coniferousForest);
        this.addSpawnBiomes(Biomes.coniferousForestSnow);
        this.addSpawnBiomes(Biomes.crag);
        this.addSpawnBiomes(Biomes.deadForest);
        this.addSpawnBiomes(Biomes.deadForestSnow);
        this.addSpawnBiomes(Biomes.deciduousForest);
        this.addSpawnBiomes(Biomes.dunes);
        this.addSpawnBiomes(Biomes.frostForest);
        this.addSpawnBiomes(Biomes.glacier);
        this.addSpawnBiomes(Biomes.grassland);
        this.addSpawnBiomes(Biomes.grove);
        this.addSpawnBiomes(Biomes.heathland);
        this.addSpawnBiomes(Biomes.highland);
        this.addSpawnBiomes(Biomes.lushDesert);
        this.addSpawnBiomes(Biomes.lushSwamp);
        this.addSpawnBiomes(Biomes.mangrove);
        this.addSpawnBiomes(Biomes.mapleWoods);
        this.addSpawnBiomes(Biomes.marsh);
        this.addSpawnBiomes(Biomes.meadow);
        this.addSpawnBiomes(Biomes.mesa);
        this.addSpawnBiomes(Biomes.mountain);
        this.addSpawnBiomes(Biomes.pasture);
        this.addSpawnBiomes(Biomes.prairie);
        this.addSpawnBiomes(Biomes.quagmire);
        this.addSpawnBiomes(Biomes.rainforest);
        this.addSpawnBiomes(Biomes.redwoodForest);
        this.addSpawnBiomes(Biomes.savanna);
        this.addSpawnBiomes(Biomes.scrubland);
        this.addSpawnBiomes(Biomes.seasonalForest);
        this.addSpawnBiomes(Biomes.shrubland);
        this.addSpawnBiomes(Biomes.steppe);
        this.addSpawnBiomes(Biomes.temperateRainforest);
        this.addSpawnBiomes(Biomes.tropicalRainforest);
        this.addSpawnBiomes(Biomes.tropics);
        this.addSpawnBiomes(Biomes.tundra);
        this.addSpawnBiomes(Biomes.volcano);
        this.addSpawnBiomes(Biomes.wetland);
        this.addSpawnBiomes(Biomes.woodland);
        this.addSpawnBiomes(Biomes.forestNew);
        this.addSpawnBiomes(Biomes.plainsNew);
        this.addSpawnBiomes(Biomes.taigaNew);
        this.addSpawnBiomes(Biomes.jungleNew);
    }

    public WorldChunkManagerBOP(long par1, WorldType par3WorldType) {
        this();
        GenLayer[] agenlayer = BiomeLayer.initializeAllBiomeGenerators(par1, par3WorldType, 0);
        agenlayer = this.getModdedBiomeGenerators(par3WorldType, par1, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
    }

    public WorldChunkManagerBOP(World par1World) {
        this(par1World.func_72905_C(), par1World.func_72912_H().func_76067_t());
    }

    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        return this.biomeCache.func_76837_b(par1, par2);
    }

    public float[] func_76936_a(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8 = (float)BiomeGenBase.field_76773_a[var6[var7]].func_76744_g() / 65536.0f;
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            par1ArrayOfFloat[var7] = var8;
        }
        return par1ArrayOfFloat;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public float[] func_76934_b(float[] par1ArrayOfFloat, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfFloat == null || par1ArrayOfFloat.length < par4 * par5) {
            par1ArrayOfFloat = new float[par4 * par5];
        }
        int[] var6 = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            float var8 = (float)BiomeGenBase.field_76773_a[var6[var7]].func_76734_h() / 65536.0f;
            if (var8 > 1.0f) {
                var8 = 1.0f;
            }
            par1ArrayOfFloat[var7] = var8;
        }
        return par1ArrayOfFloat;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        int[] var6 = this.genBiomes.func_75904_a(par2, par3, par4, par5);
        for (int var7 = 0; var7 < par4 * par5; ++var7) {
            par1ArrayOfBiomeGenBase[var7] = BiomeGenBase.field_76773_a[var6[var7]];
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5, boolean par6) {
        IntCache.func_76446_a();
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < par4 * par5) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[par4 * par5];
        }
        if (par6 && par4 == 16 && par5 == 16 && (par2 & 0xF) == 0 && (par3 & 0xF) == 0) {
            BiomeGenBase[] var9 = this.biomeCache.func_76839_e(par2, par3);
            System.arraycopy(var9, 0, par1ArrayOfBiomeGenBase, 0, par4 * par5);
            return par1ArrayOfBiomeGenBase;
        }
        int[] var7 = this.biomeIndexLayer.func_75904_a(par2, par3, par4, par5);
        for (int var8 = 0; var8 < par4 * par5; ++var8) {
            par1ArrayOfBiomeGenBase[var8] = BiomeGenBase.field_76773_a[var7[var8]];
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        IntCache.func_76446_a();
        int var5 = par1 - par3 >> 2;
        int var6 = par2 - par3 >> 2;
        int var7 = par1 + par3 >> 2;
        int var8 = par2 + par3 >> 2;
        int var9 = var7 - var5 + 1;
        int var10 = var8 - var6 + 1;
        int[] var11 = this.genBiomes.func_75904_a(var5, var6, var9, var10);
        for (int var12 = 0; var12 < var9 * var10; ++var12) {
            BiomeGenBase var13 = BiomeGenBase.field_76773_a[var11[var12]];
            if (par4List.contains(var13)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition func_76941_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        IntCache.func_76446_a();
        int var6 = par1 - par3 >> 2;
        int var7 = par2 - par3 >> 2;
        int var8 = par1 + par3 >> 2;
        int var9 = par2 + par3 >> 2;
        int var10 = var8 - var6 + 1;
        int var11 = var9 - var7 + 1;
        int[] var12 = this.genBiomes.func_75904_a(var6, var7, var10, var11);
        ChunkPosition var13 = null;
        int var14 = 0;
        for (int var15 = 0; var15 < var12.length; ++var15) {
            int var16 = var6 + var15 % var10 << 2;
            int var17 = var7 + var15 / var10 << 2;
            BiomeGenBase var18 = BiomeGenBase.field_76773_a[var12[var15]];
            if (!par4List.contains(var18) || var13 != null && par5Random.nextInt(var14 + 1) != 0) continue;
            var13 = new ChunkPosition(var16, 0, var17);
            ++var14;
        }
        return var13;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    private void addSpawnBiomes(Optional biome) {
        if (biome.isPresent()) {
            this.biomesToSpawnIn.add(biome.get());
        }
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newBiomeGens;
    }
}

