/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.helpers;

import biomesoplenty.configuration.BOPConfiguration;
import biomesoplenty.world.WorldTypeBOP;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.Property;

public class Version
implements Runnable {
    private static Version instance = new Version();
    public static final String VERSION = "0.5.9.3";
    private static final String REMOTE_VERSION_FILE = "https://raw.github.com/BiomesOPlenty/BiomesOPlenty/master/version.txt";
    private static final String REMOTE_CHANGELOG_ROOT = "https://raw.github.com/BiomesOPlenty/BiomesOPlenty/master/changelog/";
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    private static String recommendedVersion;
    private static String[] cachedChangelog;

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isOutdated() {
        return currentVersion == EnumUpdateState.OUTDATED;
    }

    public static boolean needsUpdateNoticeAndMarkAsSeen() {
        return Version.isOutdated();
    }

    public static boolean needsBOPWorldtypeAndMarkAsSeen(World world) {
        WorldType terrainType = world.func_72912_H().func_76067_t();
        WorldTypeBOP bopType = new WorldTypeBOP();
        Property property = BOPConfiguration.config.get("Vars", "Seen WorldType Msg", false);
        String worldTypeProp = property.getString();
        if (terrainType == null || property.getBoolean(false)) {
            return false;
        }
        if (terrainType.func_77127_a().equals(bopType.func_77127_a())) {
            property.set(true);
            BOPConfiguration.config.save();
            return false;
        }
        property.set(true);
        BOPConfiguration.config.save();
        return true;
    }

    public static String getRecommendedVersion() {
        return recommendedVersion;
    }

    public static void versionCheck() {
        try {
            if ("0.0.0".equals(VERSION)) {
                return;
            }
            String location = REMOTE_VERSION_FILE;
            URLConnection conn = null;
            while (location != null && !location.isEmpty()) {
                URL url = new URL(location);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
                location = conn.getHeaderField("Location");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            String mcVersion = Loader.instance().getMinecraftModContainer().getVersion();
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith(mcVersion) || !line.contains("BiomesOPlenty")) continue;
                String[] tokens = line.split(":");
                recommendedVersion = tokens[2];
                if (!line.endsWith(VERSION)) continue;
                FMLCommonHandler.instance().getFMLLogger().log(Level.FINER, "[BiomesOPlenty] Using the latest version [" + Version.getVersion() + "] for Minecraft " + mcVersion);
                currentVersion = EnumUpdateState.CURRENT;
                return;
            }
            FMLCommonHandler.instance().getFMLLogger().log(Level.WARNING, "[BiomesOPlenty] Using outdated version [0.5.9.3] for Minecraft " + mcVersion + ". Consider updating.");
            currentVersion = EnumUpdateState.OUTDATED;
        }
        catch (Exception e) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.WARNING, "[BiomesOPlenty] Unable to read from remote version authority.");
            FMLCommonHandler.instance().getFMLLogger().log(Level.WARNING, e.toString());
            currentVersion = EnumUpdateState.CONNECTION_ERROR;
        }
    }

    @Override
    public void run() {
        currentVersion = null;
        FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[BiomesOPlenty] Beginning version check");
        try {
            for (int count = 0; count < 3 && (currentVersion == null || currentVersion == EnumUpdateState.CONNECTION_ERROR); ++count) {
                Version.versionCheck();
                if (currentVersion != EnumUpdateState.CONNECTION_ERROR) continue;
                FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[BiomesOPlenty] Version check attempt " + count + " failed, trying again in 10 seconds");
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (currentVersion == EnumUpdateState.CONNECTION_ERROR) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[BiomesOPlenty] Version check failed");
        }
    }

    public static void check() {
        new Thread(instance).start();
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR;

    }
}

