/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.helpers;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.logging.Level;

public class Localizations {
    private static final String localizationLocation = "/mods/biomesoplenty/localizations/";
    public static String[] localeFiles = new String[]{"/mods/biomesoplenty/localizations/en_US.xml", "/mods/biomesoplenty/localizations/de_DE.xml", "/mods/biomesoplenty/localizations/nl_NL.xml", "/mods/biomesoplenty/localizations/ru_RU.xml", "/mods/biomesoplenty/localizations/zh_CN.xml", "/mods/biomesoplenty/localizations/pl_PL.xml", "/mods/biomesoplenty/localizations/fr_FR.xml", "/mods/biomesoplenty/localizations/fr_CA.xml", "/mods/biomesoplenty/localizations/ja_JP.xml"};
    public static final String[] shardNames = new String[]{"Amethyst"};
    public static final String[] toolMaterialNames = new String[]{"Amethyst"};
    public static final String[] materialTypes = new String[]{"ToolRod", "PickaxeHead", "ShovelHead", "AxeHead", "SwordBlade", "LargeGuard", "MediumGuard", "Crossbar", "Binding", "FrypanHead", "SignHead", "LumberHead", "KnifeBlade", "ChiselHead", "ScytheBlade", "LumberHead", "ThickRod", "ThickBinding", "LargeSwordBlade", "LargePlate", "ExcavatorHead", "HammerHead", "FullGuard"};
    public static final String[] materialNames = new String[]{" Rod", " Pickaxe Head", " Shovel Head", " Axe Head", " Sword Blade", " Wide Guard", " Hand Guard", " Crossbar", " Binding", " Pan", " Board", " Broad Axe Head", " Knife Blade", " Chisel Head", " Scythe Blade", " Broad Axe Head", " Tough Tool Rod", " Tough Binding", " Large Sword Blade", " Large Plate", " Excavator Head", " Hammer Head", " Full Guard"};

    public static boolean isXMLLanguageFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    public static String getLocaleFromFileName(String fileName) {
        FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[BiomesOPlenty] Localizations loaded for " + fileName.substring(fileName.lastIndexOf(47) + 1, fileName.lastIndexOf(46)));
        return fileName.substring(fileName.lastIndexOf(47) + 1, fileName.lastIndexOf(46));
    }

    public String getLocalizedString(String key) {
        return LanguageRegistry.instance().getStringLocalization(key);
    }

    public static void loadLanguages() {
        for (String localizationFile : localeFiles) {
            LanguageRegistry.instance().loadLocalization(localizationFile, Localizations.getLocaleFromFileName(localizationFile), Localizations.isXMLLanguageFile(localizationFile));
        }
        for (int mat = 0; mat < materialTypes.length; ++mat) {
            for (int type = 0; type < toolMaterialNames.length; ++type) {
                String internalName = "item.bop.tc." + materialTypes[mat] + "." + toolMaterialNames[type] + ".name";
                String visibleName = toolMaterialNames[type] + materialNames[mat];
                LanguageRegistry.instance().addStringLocalization(internalName, "en_US", visibleName);
            }
        }
        for (int i = 0; i < shardNames.length; ++i) {
            String internalName = "item.bop.tc.ToolShard." + toolMaterialNames[i] + ".name";
            String visibleName = shardNames[i];
            LanguageRegistry.instance().addStringLocalization(internalName, "en_US", visibleName);
        }
    }
}

