/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.configuration;

import biomesoplenty.api.Potions;
import biomesoplenty.potions.PotionEventHandler;
import biomesoplenty.potions.PotionParalysis;
import com.google.common.base.Optional;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.lang.reflect.Field;
import java.util.logging.Level;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;

public class BOPPotions {
    public static int potionOffset;
    private static final int MAXNEWPOTIONS = 8;

    public static void init() {
        BOPPotions.extendPotionsArray();
        BOPPotions.intializePotions();
        BOPPotions.registerPotionNames();
        MinecraftForge.EVENT_BUS.register((Object)new PotionEventHandler());
    }

    private static void intializePotions() {
        Potions.paralysis = Optional.of((Object)new PotionParalysis(potionOffset + 0, true, 16767262).func_76390_b("potion.paralysis"));
    }

    private static void registerPotionNames() {
        LanguageRegistry.instance().addStringLocalization("potion.nourishment", "en_US", "Nourishment");
        LanguageRegistry.instance().addStringLocalization("potion.paralysis", "en_US", "Paralysis");
    }

    private static void extendPotionsArray() {
        Field[] fields;
        FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[BiomesOPlenty] Extending Potions Array.");
        potionOffset = Potion.field_76425_a.length;
        Potion[] potionTypes = new Potion[potionOffset + 8];
        System.arraycopy(Potion.field_76425_a, 0, potionTypes, 0, potionOffset);
        Field field = null;
        for (Field f : fields = Potion.class.getDeclaredFields()) {
            if (!f.getName().equals("potionTypes") && !f.getName().equals("field_76425_a")) continue;
            field = f;
            break;
        }
        try {
            field.setAccessible(true);
            Field modfield = Field.class.getDeclaredField("modifiers");
            modfield.setAccessible(true);
            modfield.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, potionTypes);
        }
        catch (Exception e) {
            System.err.println("[BiomesOPlenty] Severe error, please report this to the mod author:");
            System.err.println(e);
        }
    }
}

