/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.configuration;

import biomesoplenty.api.Fluids;
import biomesoplenty.configuration.BOPConfiguration;
import biomesoplenty.fluids.BlockFluidLiquidPoison;
import biomesoplenty.fluids.BlockFluidSpringWater;
import biomesoplenty.fluids.LiquidPoisonFluid;
import biomesoplenty.fluids.SpringWaterFluid;
import biomesoplenty.items.ItemBOPBucket;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class BOPFluids {
    public static void init() {
        BOPFluids.registerFluids();
        BOPFluids.initializeLiquids();
        BOPFluids.initializeContainers();
        BOPFluids.registerBlocks();
    }

    private static void registerFluids() {
        Fluids.liquidPoisonFluid = Optional.of((Object)new LiquidPoisonFluid("bop.liquidPoison").setBlockID(BOPConfiguration.liquidPoisonStillID));
        FluidRegistry.registerFluid((Fluid)Fluids.liquidPoisonFluid.get());
        Fluids.springWaterFluid = Optional.of((Object)new SpringWaterFluid("bop.springWater").setBlockID(BOPConfiguration.springWaterStillID));
        FluidRegistry.registerFluid((Fluid)Fluids.springWaterFluid.get());
    }

    private static void initializeLiquids() {
        Fluids.liquidPoison = Optional.of((Object)new BlockFluidLiquidPoison(BOPConfiguration.liquidPoisonStillID, (Fluid)Fluids.liquidPoisonFluid.get(), Material.field_76244_g).func_71864_b("bop.liquidPoison"));
        Fluids.springWater = Optional.of((Object)new BlockFluidSpringWater(BOPConfiguration.springWaterStillID, (Fluid)Fluids.springWaterFluid.get(), Material.field_76244_g).func_71864_b("bop.springWater"));
    }

    private static void initializeContainers() {
        Fluids.bopBucket = Optional.of((Object)new ItemBOPBucket(BOPConfiguration.bopBucketID).func_77625_d(1).func_77655_b("bop.bopBucket"));
        FluidContainerRegistry.registerFluidContainer((Fluid)Fluids.liquidPoisonFluid.get(), new ItemStack((Item)Fluids.bopBucket.get(), 1, 1), new ItemStack(Item.field_77788_aw));
        FluidContainerRegistry.registerFluidContainer((Fluid)Fluids.springWaterFluid.get(), new ItemStack((Item)Fluids.bopBucket.get(), 1, 2), new ItemStack((Item)Fluids.bopBucket.get(), 1, 0));
    }

    private static void registerBlocks() {
        GameRegistry.registerBlock((Block)((Block)Fluids.liquidPoison.get()), (String)"liquidPoison");
        GameRegistry.registerBlock((Block)((Block)Fluids.springWater.get()), (String)"springWater");
    }
}

