/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.blocks;

import biomesoplenty.BiomesOPlenty;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

public class BlockBOPStairs
extends BlockStairs {
    private static final String[] woodTypes = new String[]{"acacia", "cherry", "dark", "fir", "holy", "magic", "mangrove", "palm", "redwood", "willow", "pine", "hell_bark", "jacaranda"};
    private static final String[] stoneTypes = new String[]{"redcobble", "redbrick", "mudbrick", "holycobble", "holybrick"};
    private Icon[] textures;
    private final Category category;

    public BlockBOPStairs(int blockID, Block model, Category cat) {
        super(blockID, model, 0);
        this.category = cat;
        BlockBOPStairs.setBurnProperties((int)this.field_71990_ca, (int)5, (int)20);
        this.func_71868_h(0);
        this.func_71849_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_94332_a(IconRegister iconRegister) {
        if (this.isStoneCategory(this.category.toString())) {
            this.textures = new Icon[stoneTypes.length];
            for (int i = 0; i < stoneTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + stoneTypes[i]);
            }
        } else {
            this.textures = new Icon[woodTypes.length];
            for (int i = 0; i < woodTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:plank_" + woodTypes[i]);
            }
        }
    }

    public boolean isWoodCategory(String block) {
        String type = Category.valueOf(block).type;
        return type == "wood";
    }

    public boolean isStoneCategory(String block) {
        String type = Category.valueOf(block).type;
        return type == "stone";
    }

    public static int getWoodCategoryAmount() {
        int woodCatNo = 0;
        for (Category cat : Category.values()) {
            if (!cat.values.contains("wood")) continue;
            ++woodCatNo;
        }
        return woodCatNo;
    }

    public static int getStoneCategoryAmount() {
        int woodCatNo = 0;
        for (Category cat : Category.values()) {
            if (!cat.values.contains("stone")) continue;
            ++woodCatNo;
        }
        return woodCatNo;
    }

    public Icon func_71858_a(int side, int meta) {
        int adjCat = this.category.ordinal();
        if (this.isStoneCategory(this.category.toString())) {
            adjCat -= BlockBOPStairs.getWoodCategoryAmount();
        }
        return this.textures[adjCat];
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public static enum Category {
        ACACIA("wood"),
        CHERRY("wood"),
        DARK("wood"),
        FIR("wood"),
        HOLY("wood"),
        MAGIC("wood"),
        MANGROVE("wood"),
        PALM("wood"),
        REDWOOD("wood"),
        WILLOW("wood"),
        PINE("wood"),
        HELL_BARK("wood"),
        JACARANDA("wood"),
        RED_COBBLE("stone"),
        RED_BRICKS("stone"),
        MUD_BRICKS("stone"),
        HOLY_COBBLE("stone"),
        HOLY_BRICKS("stone");

        private final List values;
        private String type;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Category() {
            void type;
            this.type = type;
            this.values = Arrays.asList(type);
        }
    }
}

