/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.api.Blocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHalfSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockBOPSlab
extends BlockHalfSlab {
    private static final String[] woodTypes = new String[]{"acacia", "cherry", "dark", "fir", "holy", "magic", "mangrove", "palm", "redwood", "willow", "pine", "hell_bark", "jacaranda"};
    private static final String[] rockTypes = new String[]{"redcobble", "redbrick", "mudbrick", "holycobble", "holybrick"};
    private Icon[] textures;
    protected final boolean isDoubleSlab;
    private final SlabCategory category;

    public BlockBOPSlab(int par1, boolean par2, Material material, SlabCategory cat) {
        super(par1, par2, material);
        this.isDoubleSlab = par2;
        this.category = cat;
        if (material == Material.field_76245_d) {
            BlockBOPSlab.setBurnProperties((int)this.field_71990_ca, (int)5, (int)20);
            this.func_71848_c(2.0f);
            this.func_71894_b(5.0f);
            this.func_71884_a(Block.field_71967_e);
        } else if (material == Material.field_76246_e) {
            this.func_71884_a(Block.field_71976_h);
        }
        if (!par2) {
            this.func_71849_a(BiomesOPlenty.tabBiomesOPlenty);
        }
        BlockBOPSlab.field_71982_s[this.field_71990_ca] = true;
    }

    public void func_94332_a(IconRegister iconRegister) {
        if (this.category == SlabCategory.STONE) {
            this.textures = new Icon[rockTypes.length];
            for (int i = 0; i < rockTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + rockTypes[i]);
            }
        } else {
            this.textures = new Icon[woodTypes.length];
            for (int i = 0; i < woodTypes.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:plank_" + woodTypes[i]);
            }
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (this.category == SlabCategory.STONE) {
            return this.textures[BlockBOPSlab.getTypeFromMeta(meta)];
        }
        return this.textures[BlockBOPSlab.getTypeFromMeta(meta) + this.category.ordinal() * 8];
    }

    public void func_71879_a(int blockID, CreativeTabs creativeTabs, List list) {
        int max = 0;
        if (this.category == SlabCategory.WOOD1) {
            max = 8;
        } else if (this.category == SlabCategory.WOOD2) {
            max = 5;
        } else if (this.category == SlabCategory.STONE) {
            max = 5;
        }
        for (int i = 0; i < max; ++i) {
            list.add(new ItemStack(blockID, 1, i));
        }
    }

    public String func_72240_d(int meta) {
        if (this.category == SlabCategory.STONE) {
            return rockTypes[BlockBOPSlab.getTypeFromMeta(meta)] + "Slab";
        }
        return woodTypes[this.getWoodType(meta)] + "Slab";
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public int func_71885_a(int meta, Random par2Random, int par3) {
        if (this.isDoubleSlab) {
            if (this.field_71990_ca == ((BlockHalfSlab)Blocks.woodenDoubleSlab1.get()).field_71990_ca) {
                return ((BlockHalfSlab)Blocks.woodenSingleSlab1.get()).field_71990_ca;
            }
            if (this.field_71990_ca == ((BlockHalfSlab)Blocks.woodenDoubleSlab2.get()).field_71990_ca) {
                return ((BlockHalfSlab)Blocks.woodenSingleSlab2.get()).field_71990_ca;
            }
            return ((BlockHalfSlab)Blocks.stoneSingleSlab.get()).field_71990_ca;
        }
        return this.field_71990_ca;
    }

    public float func_71934_m(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float hardness = this.field_71989_cb;
        if (this.category == SlabCategory.STONE) {
            switch (BlockBOPSlab.getTypeFromMeta(meta)) {
                case 0: 
                case 3: {
                    hardness = 1.6f;
                    break;
                }
                case 1: 
                case 4: {
                    hardness = 1.1f;
                    break;
                }
                case 2: {
                    hardness = 1.0f;
                }
            }
        }
        return hardness;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        float resistance = this.field_71989_cb;
        if (this.category == SlabCategory.STONE) {
            switch (BlockBOPSlab.getTypeFromMeta(meta)) {
                case 0: 
                case 3: {
                    resistance = 7.0f;
                    break;
                }
                case 1: 
                case 4: {
                    resistance = 7.5f;
                    break;
                }
                case 2: {
                    resistance = 2.0f;
                }
            }
        }
        return resistance / 5.0f;
    }

    public int func_71922_a(World par1World, int par2, int par3, int par4) {
        return !this.isDoubleSlab ? this.field_71990_ca : (this.field_71990_ca == ((BlockHalfSlab)Blocks.woodenDoubleSlab1.get()).field_71990_ca ? ((BlockHalfSlab)Blocks.woodenSingleSlab1.get()).field_71990_ca : (this.field_71990_ca == ((BlockHalfSlab)Blocks.woodenDoubleSlab2.get()).field_71990_ca ? ((BlockHalfSlab)Blocks.woodenSingleSlab2.get()).field_71990_ca : ((BlockHalfSlab)Blocks.stoneSingleSlab.get()).field_71990_ca));
    }

    protected ItemStack func_71880_c_(int par1) {
        return new ItemStack(this.field_71990_ca, 2, par1);
    }

    private int getWoodType(int meta) {
        if ((meta = BlockBOPSlab.getTypeFromMeta(meta) + this.category.ordinal() * 8) < woodTypes.length) {
            return meta;
        }
        return 0;
    }

    private static int getTypeFromMeta(int meta) {
        return meta & 7;
    }

    public static enum SlabCategory {
        WOOD1,
        WOOD2,
        STONE;

    }
}

