/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.PluginInfo;
import forestry.api.mail.EnumPostage;
import forestry.api.mail.PostManager;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.IPacketHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryBlock;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.Trigger;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.mail.CommandMail;
import forestry.mail.EnumAddressee;
import forestry.mail.GuiHandlerMail;
import forestry.mail.PacketHandlerMail;
import forestry.mail.PostRegistry;
import forestry.mail.PostalCarrier;
import forestry.mail.SaveEventHandlerMail;
import forestry.mail.TickHandlerMailClient;
import forestry.mail.gadgets.MachineMailbox;
import forestry.mail.gadgets.MachinePhilatelist;
import forestry.mail.gadgets.MachineTrader;
import forestry.mail.items.ItemCatalogue;
import forestry.mail.items.ItemLetter;
import forestry.mail.items.ItemStamps;
import forestry.mail.proxy.ProxyMail;
import forestry.mail.triggers.TriggerBuffer;
import forestry.mail.triggers.TriggerHasMail;
import forestry.mail.triggers.TriggerLowInput;
import forestry.mail.triggers.TriggerLowPaper;
import forestry.mail.triggers.TriggerLowStamps;
import forestry.plugins.NativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.liquids.LiquidStack;

@PluginInfo(pluginID="Mail", name="Mail", author="SirSengir", url="http://forestry.sengir.net/", description="Adds Forestry's mail and trade system.")
public class PluginMail
extends NativePlugin {
    @SidedProxy(clientSide="forestry.mail.proxy.ClientProxyMail", serverSide="forestry.mail.proxy.ProxyMail")
    public static ProxyMail proxy;
    public static Trigger triggerHasMail;
    public static Trigger lowPaper25;
    public static Trigger lowPaper10;
    public static Trigger lowPostage40;
    public static Trigger lowPostage20;
    public static Trigger lowInput25;
    public static Trigger lowInput10;
    public static Trigger highBuffer75;
    public static Trigger highBuffer90;
    public static MachineDefinition definitionMailbox;
    public static MachineDefinition definitionTradestation;
    public static MachineDefinition definitionPhilatelist;
    public static ItemStamps.StampInfo[] stampDefinitions;

    @Override
    public boolean isAvailable() {
        return !Config.disableMail;
    }

    @Override
    public void preInit() {
        super.preInit();
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerMailClient(), (Side)Side.CLIENT);
        triggerHasMail = new TriggerHasMail(611);
        lowPaper25 = new TriggerLowPaper(612, 0.25f);
        lowPaper10 = new TriggerLowPaper(613, 0.1f);
        lowPostage40 = new TriggerLowStamps(614, 40);
        lowPostage20 = new TriggerLowStamps(615, 20);
        lowInput25 = new TriggerLowInput(616, 0.25f);
        lowInput10 = new TriggerLowInput(617, 0.1f);
        highBuffer75 = new TriggerBuffer(618, 0.75f);
        highBuffer90 = new TriggerBuffer(619, 0.9f);
        int blockid = Config.getOrCreateBlockIdProperty("mail", 1407);
        definitionMailbox = new MachineDefinition(blockid, 0, "forestry.Mailbox", MachineMailbox.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{" # ", "#Y#", "XXX", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), Block.field_72077_au, Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockid, 1, 0))).setFaces(0, 1, 2, 2, 2, 2, 0, 7);
        definitionTradestation = new MachineDefinition(blockid, 1, "forestry.Tradestation", MachineTrader.class, ShapedRecipeCustom.createShapedRecipe(new Object[]{"Z#Z", "#Y#", "XWX", Character.valueOf('#'), new ItemStack(ForestryItem.tubes, 1, 2), Character.valueOf('X'), Block.field_72077_au, Character.valueOf('Y'), ForestryItem.sturdyCasing, Character.valueOf('Z'), new ItemStack(ForestryItem.tubes, 1, 3), Character.valueOf('W'), new ItemStack(ForestryItem.circuitboards, 1, 2)}, new ItemStack(blockid, 1, 1))).setFaces(0, 1, 2, 3, 4, 4, 0, 7);
        definitionPhilatelist = new MachineDefinition(blockid, 2, "forestry.Philatelist", MachinePhilatelist.class, new IRecipe[0]).setFaces(0, 1, 2, 3, 2, 2, 0, 7);
        ForestryBlock.mail = new BlockBase(blockid, Material.field_76243_f, new MachineDefinition[]{definitionMailbox, definitionTradestation, definitionPhilatelist}).func_71864_b("for.mail");
        Item.field_77698_e[ForestryBlock.mail.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.mail.field_71990_ca] = new ItemForestryBlock(ForestryBlock.mail.field_71990_ca - 256, "for.mail");
        PostManager.postRegistry = new PostRegistry();
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.PLAYER));
        PostManager.postRegistry.registerCarrier(new PostalCarrier(EnumAddressee.TRADER));
    }

    @Override
    public void doInit() {
        super.doInit();
        proxy.addLocalizations();
        definitionMailbox.register();
        definitionTradestation.register();
        definitionPhilatelist.register();
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerMail();
    }

    @Override
    public IPacketHandler getPacketHandler() {
        return new PacketHandlerMail();
    }

    @Override
    protected void registerItems() {
        stampDefinitions = new ItemStamps.StampInfo[]{new ItemStamps.StampInfo("1n", EnumPostage.P_1, ForestryItem.apatite, 4885671, 0xFFFFFF), new ItemStamps.StampInfo("2n", EnumPostage.P_2, "ingotCopper", 15255572, 0xFFFFFF), new ItemStamps.StampInfo("5n", EnumPostage.P_5, "ingotTin", 10225415, 0xFFFFFF), new ItemStamps.StampInfo("10n", EnumPostage.P_10, Item.field_77717_p, 8114616, 0xFFFFFF), new ItemStamps.StampInfo("20n", EnumPostage.P_20, Item.field_77702_n, 16748593, 0xFFF7DD), new ItemStamps.StampInfo("50n", EnumPostage.P_50, Item.field_77817_bH, 6566359, 0xFFF7DD), new ItemStamps.StampInfo("100n", EnumPostage.P_100, Item.field_82792_bS, 14102970, 0xFFF7DD)};
        ForestryItem.stamps = new ItemStamps(Config.getOrCreateItemIdProperty("stamps", 13116), stampDefinitions).func_77655_b("stamps");
        ForestryItem.letters = new ItemLetter(Config.getOrCreateItemIdProperty("letters", 13117)).func_77655_b("letters");
        ForestryItem.catalogue = new ItemCatalogue(Config.getOrCreateItemIdProperty("catalogue", 13118)).func_77655_b("catalogue");
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    protected void registerRecipes() {
        Proxies.common.addShapelessRecipe(new ItemStack(ForestryItem.letters, 1), new Object[]{Item.field_77759_aK, new ItemStack(ForestryItem.propolis, 1, Short.MAX_VALUE)});
        if (Config.craftingStampsEnabled) {
            for (int i = 0; i < stampDefinitions.length; ++i) {
                if (Config.collectorStamps.contains(PluginMail.stampDefinitions[i].name)) continue;
                Proxies.common.addRecipe(new ItemStack(ForestryItem.stamps, 9, i), new Object[]{"XXX", "###", "ZZZ", Character.valueOf('X'), stampDefinitions[i].getCraftingIngredient(), Character.valueOf('#'), Item.field_77759_aK, Character.valueOf('Z'), ForestryItem.honeyDrop});
                RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(ForestryItem.liquidSeedOil, 300), null, new ItemStack(ForestryItem.stamps, 9, i), new Object[]{"XXX", "###", Character.valueOf('X'), stampDefinitions[i].getCraftingIngredient(), Character.valueOf('#'), Item.field_77759_aK});
            }
        }
        Proxies.common.addRecipe(new ItemStack(Item.field_77759_aK), new Object[]{"###", Character.valueOf('#'), new ItemStack(ForestryItem.letters, 1, Short.MAX_VALUE)});
        RecipeManagers.carpenterManager.addRecipe(10, new LiquidStack(Block.field_71943_B, 250), null, new ItemStack(ForestryItem.letters, 1), new Object[]{"###", "###", Character.valueOf('#'), ForestryItem.woodPulp});
        Proxies.common.addShapelessRecipe(new ItemStack(ForestryItem.catalogue), new Object[]{new ItemStack(ForestryItem.stamps, 1, Short.MAX_VALUE), new ItemStack(Item.field_77760_aL)});
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return new SaveEventHandlerMail();
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }

    @Override
    public ICommand[] getConsoleCommands() {
        return new ICommand[]{new CommandMail()};
    }
}

