/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.PluginInfo;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.GameMode;
import forestry.core.circuits.Circuit;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.BlockBase;
import forestry.core.gadgets.MachineDefinition;
import forestry.core.interfaces.IOreDictionaryHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.items.ItemForestryBlock;
import forestry.core.proxy.Proxies;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.ShapedRecipeCustom;
import forestry.energy.GuiHandlerEnergy;
import forestry.energy.circuits.CircuitElectricBoost;
import forestry.energy.circuits.CircuitElectricChoke;
import forestry.energy.circuits.CircuitElectricEfficiency;
import forestry.energy.circuits.CircuitFireDampener;
import forestry.energy.gadgets.EngineBronze;
import forestry.energy.gadgets.EngineClockwork;
import forestry.energy.gadgets.EngineCopper;
import forestry.energy.gadgets.EngineDefinition;
import forestry.energy.gadgets.EngineTin;
import forestry.energy.gadgets.MachineGenerator;
import forestry.energy.proxy.ProxyEnergy;
import forestry.plugins.NativePlugin;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@PluginInfo(pluginID="Energy", name="Energy", author="SirSengir", url="http://forestry.sengir.net/", description="Adds several engines compatible with BuildCraft 3 as well as a generator for IC2.")
public class PluginEnergy
extends NativePlugin {
    @SidedProxy(clientSide="forestry.energy.proxy.ClientProxyEnergy", serverSide="forestry.energy.proxy.ProxyEnergy")
    public static ProxyEnergy proxy;
    public static MachineDefinition definitionEngineTin;
    public static MachineDefinition definitionEngineCopper;
    public static MachineDefinition definitionEngineBronze;
    public static MachineDefinition definitionEngineClockwork;
    public static MachineDefinition definitionGenerator;

    @Override
    public boolean isAvailable() {
        return !Config.disableEnergy;
    }

    @Override
    public void preInit() {
        super.preInit();
        int blockid = Config.getOrCreateBlockIdProperty("engine", 1404);
        definitionEngineTin = new EngineDefinition(blockid, 0, "forestry.EngineTin", EngineTin.class, proxy.getRenderDefaultEngine("/gfx/forestry/blocks/engine_tin_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"###", " X ", "YVY", Character.valueOf('#'), "ingotTin", Character.valueOf('X'), Block.field_71946_M, Character.valueOf('Y'), "gearTin", Character.valueOf('V'), Block.field_71963_Z}, new ItemStack(blockid, 1, 0)));
        definitionEngineCopper = new EngineDefinition(blockid, 1, "forestry.EngineCopper", EngineCopper.class, proxy.getRenderDefaultEngine("/gfx/forestry/blocks/engine_copper_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"###", " X ", "YVY", Character.valueOf('#'), "ingotCopper", Character.valueOf('X'), Block.field_71946_M, Character.valueOf('Y'), "gearCopper", Character.valueOf('V'), Block.field_71963_Z}, new ItemStack(blockid, 1, 1)));
        definitionEngineBronze = new EngineDefinition(blockid, 2, "forestry.EngineBronze", EngineBronze.class, proxy.getRenderDefaultEngine("/gfx/forestry/blocks/engine_bronze_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"###", " X ", "YVY", Character.valueOf('#'), "ingotBronze", Character.valueOf('X'), Block.field_71946_M, Character.valueOf('Y'), "gearBronze", Character.valueOf('V'), Block.field_71963_Z}, new ItemStack(blockid, 1, 2)));
        ShapedRecipeCustom clockworkRecipe = null;
        if (GameMode.getGameMode().getBooleanSetting("energy.engine.clockwork")) {
            clockworkRecipe = ShapedRecipeCustom.createShapedRecipe(new Object[]{"###", " X ", "ZVY", Character.valueOf('#'), "plankWood", Character.valueOf('X'), Block.field_71946_M, Character.valueOf('Y'), Item.field_77752_aS, Character.valueOf('Z'), ForestryItem.gearCopper, Character.valueOf('V'), Block.field_71963_Z}, new ItemStack(blockid, 1, 4));
        }
        definitionEngineClockwork = new EngineDefinition(blockid, 4, "forestry.EngineClockwork", EngineClockwork.class, proxy.getRenderDefaultEngine("/gfx/forestry/blocks/engine_clock_"), clockworkRecipe);
        definitionGenerator = new MachineDefinition(blockid, 3, "forestry.Generator", MachineGenerator.class, Proxies.render.getRenderDefaultMachine("/gfx/forestry/blocks/generator_"), ShapedRecipeCustom.createShapedRecipe(new Object[]{"X#X", "XYX", "X#X", Character.valueOf('#'), Block.field_71946_M, Character.valueOf('X'), Item.field_77717_p, Character.valueOf('Y'), ForestryItem.sturdyCasing}, new ItemStack(blockid, 1, 3)));
        ForestryBlock.engine = new BlockBase(blockid, Material.field_76243_f, new MachineDefinition[]{definitionEngineTin, definitionEngineCopper, definitionEngineBronze, definitionGenerator, definitionEngineClockwork}, true).func_71864_b("for.engine");
        Item.field_77698_e[ForestryBlock.engine.field_71990_ca] = null;
        Item.field_77698_e[ForestryBlock.engine.field_71990_ca] = new ItemForestryBlock(ForestryBlock.engine.field_71990_ca - 256, "for.engine");
        ChipsetManager.circuitRegistry.registerLegacyMapping(1, "forestry.energyChoke1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(2, "forestry.energyDampener1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(3, "forestry.energyEfficiency1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(4, "forestry.energyBoost1");
        ChipsetManager.circuitRegistry.registerLegacyMapping(5, "forestry.energyBoost2");
    }

    @Override
    public void doInit() {
        super.doInit();
        definitionEngineTin.register();
        definitionEngineCopper.register();
        definitionEngineBronze.register();
        definitionGenerator.register();
        definitionEngineClockwork.register();
        GeneratorFuel.fuels.put(LiquidHelper.getLiquid((String)"ethanol", (int)1).itemID, new GeneratorFuel(LiquidHelper.getLiquid("ethanol", 1), 32, 4));
        GeneratorFuel.fuels.put(LiquidHelper.getLiquid((String)"biomass", (int)1).itemID, new GeneratorFuel(LiquidHelper.getLiquid("biomass", 1), 8, 1));
        Circuit.energyElectricChoke1 = new CircuitElectricChoke("energyChoke1");
        Circuit.energyFireDampener1 = new CircuitFireDampener("energyDampener1");
        Circuit.energyElectricEfficiency1 = new CircuitElectricEfficiency("energyEfficiency1");
        Circuit.energyElectricBoost1 = new CircuitElectricBoost("energyBoost1", 2, 7, 2, "electric.boost.1", new String[]{"Increases output by 2 MJ/t", "Increases intake by 7 EU/t"});
        Circuit.energyElectricBoost2 = new CircuitElectricBoost("energyBoost2", 2, 15, 4, "electric.boost.2", new String[]{"Increases output by 4 MJ/t", "Increases intake by 15 EU/t"});
    }

    @Override
    protected void registerItems() {
    }

    @Override
    protected void registerBackpackItems() {
    }

    @Override
    protected void registerRecipes() {
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.engine.tin");
        ChipsetManager.solderManager.addRecipe(layout, new ItemStack(ForestryItem.tubes, 1, 0), Circuit.energyElectricChoke1);
        ChipsetManager.solderManager.addRecipe(layout, new ItemStack(ForestryItem.tubes, 1, 1), Circuit.energyElectricBoost1);
        ChipsetManager.solderManager.addRecipe(layout, new ItemStack(ForestryItem.tubes, 1, 2), Circuit.energyElectricBoost2);
        ChipsetManager.solderManager.addRecipe(layout, new ItemStack(ForestryItem.tubes, 1, 3), Circuit.energyElectricEfficiency1);
    }

    @Override
    protected void registerCrates() {
    }

    @Override
    public IGuiHandler getGuiHandler() {
        return new GuiHandlerEnergy();
    }

    @Override
    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    @Override
    public IOreDictionaryHandler getDictionaryHandler() {
        return null;
    }
}

