/*
 * Decompiled with CFR 0.152.
 */
package forestry.pipes;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IAllele;
import forestry.pipes.EnumFilterType;
import forestry.pipes.PipeIconProvider;
import forestry.pipes.PipeLogicPropolis;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsPropolis
extends Pipe
implements IPipeTransportItemsHook {
    PipeLogicPropolis pipeLogic;
    IIconProvider provider;

    public PipeItemsPropolis(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicPropolis(), itemID);
        this.pipeLogic = (PipeLogicPropolis)this.logic;
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        if (this.provider == null) {
            this.provider = new PipeIconProvider();
        }
        return this.provider;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return direction.ordinal() + 1;
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        LinkedList<ForgeDirection> filteredOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> typedOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaultOrientations = new LinkedList<ForgeDirection>();
        EnumFilterType type = EnumFilterType.getType(item.getItemStack());
        IBee bee = null;
        if (type != EnumFilterType.ITEM) {
            bee = PluginApiculture.beeInterface.getMember(item.getItemStack());
        }
        for (ForgeDirection dir : possibleOrientations) {
            if (this.pipeLogic.isClosed(dir)) continue;
            if (this.pipeLogic.isIndiscriminate(dir)) {
                defaultOrientations.add(dir);
                continue;
            }
            if (!this.pipeLogic.matchType(dir, type, bee)) continue;
            if (type == EnumFilterType.ITEM) {
                filteredOrientations.add(dir);
                continue;
            }
            ArrayList filters = this.pipeLogic.getGenomeFilters(dir);
            if (filters.size() <= 0) {
                typedOrientations.add(dir);
                continue;
            }
            for (IAllele[] pattern : filters) {
                if (!this.pipeLogic.matchAllele(pattern[0], bee.getIdent()) || !this.pipeLogic.matchAllele(pattern[1], bee.getGenome().getSecondary().getUID())) continue;
                filteredOrientations.add(dir);
            }
        }
        if (filteredOrientations.size() > 0) {
            return filteredOrientations;
        }
        if (typedOrientations.size() > 0) {
            return typedOrientations;
        }
        return defaultOrientations;
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
        item.setSpeed(Utils.pipeNormalSpeed * 20.0f);
    }

    public void readjustSpeed(IPipedItem item) {
        ((PipeTransportItems)this.transport).defaultReajustSpeed(item);
    }
}

