/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.network.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.Utils;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.plugins.PluginLepidopterology;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemButterflyGE
extends ItemGE {
    EnumFlutterType type;
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public ItemButterflyGE(int id, EnumFlutterType type) {
        super(id);
        this.func_77637_a(Tabs.tabLepidopterology);
        this.type = type;
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 0;
    }

    @Override
    protected IIndividual getIndividual(ItemStack itemstack) {
        return PluginLepidopterology.butterflyInterface.getMember(itemstack);
    }

    public String func_77628_j(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return "???";
        }
        IButterfly butterfly = PluginLepidopterology.butterflyInterface.getMember(itemstack);
        if (butterfly == null) {
            return "???";
        }
        return butterfly.getDisplayName();
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IButterfly individual : PluginLepidopterology.butterflyInterface.getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret() && !Config.isDebug) continue;
            itemList.add(PluginLepidopterology.butterflyInterface.getMemberStack(individual, this.type.ordinal()));
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (!Proxies.common.isSimulating(entityItem.field_70170_p) || entityItem.field_70173_aa < 80) {
            return false;
        }
        if (entityItem.field_70170_p.func_72820_D() % 24L != 0L) {
            return false;
        }
        IButterfly butterfly = PluginLepidopterology.butterflyInterface.getMember(entityItem.func_92059_d());
        if (butterfly == null) {
            return false;
        }
        if (!butterfly.canTakeFlight(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v)) {
            return false;
        }
        if (entityItem.field_70170_p.func_72907_a(EntityButterfly.class) > PluginLepidopterology.entityConstraint) {
            return false;
        }
        if (Utils.spawnEntity(entityItem.field_70170_p, (Entity)new EntityButterfly(entityItem.field_70170_p, butterfly), entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v) != null) {
            if (entityItem.func_92059_d().field_77994_a > 1) {
                --entityItem.func_92059_d().field_77994_a;
            } else {
                entityItem.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    public int func_82790_a(ItemStack itemstack, int renderPass) {
        if (!itemstack.func_77942_o()) {
            return super.func_82790_a(itemstack, renderPass);
        }
        return this.getColourFromSpecies(AlleleManager.alleleRegistry.getIndividual(itemstack).getGenome().getPrimary(), renderPass);
    }

    @Override
    public int getColourFromSpecies(IAlleleSpecies species, int renderPass) {
        if (species != null) {
            return species.getIconColour(renderPass);
        }
        return 0xFFFFFF;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.icons = new Icon[2];
        switch (this.type) {
            case CATERPILLAR: {
                this.icons[0] = TextureManager.getInstance().registerItemTex("caterpillar.body");
                this.icons[1] = TextureManager.getInstance().registerItemTex("caterpillar.body2");
                break;
            }
            default: {
                this.icons[0] = TextureManager.getInstance().registerItemTex("liquids/jar.contents");
                this.icons[1] = TextureManager.getInstance().registerItemTex("liquids/jar.bottle");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77618_c(int i, int j) {
        if (j > 0) {
            return this.icons[1];
        }
        return this.icons[0];
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float facingX, float facingY, float facingZ) {
        if (!Proxies.common.isSimulating(world)) {
            return false;
        }
        IButterfly flutter = PluginLepidopterology.butterflyInterface.getMember(itemstack);
        if (flutter == null) {
            return false;
        }
        if (this.type == EnumFlutterType.CATERPILLAR) {
            TileEntity target = world.func_72796_p(x, y, z);
            if (!(target instanceof IButterflyNursery)) {
                return false;
            }
            IButterflyNursery pollinatable = (IButterflyNursery)target;
            if (!pollinatable.canNurse(flutter)) {
                return false;
            }
            pollinatable.setCaterpillar(flutter);
            Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, world, x, y, z, world.func_72798_a(x, y, z), 0);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
            return true;
        }
        return false;
    }
}

