/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.items;

import forestry.api.core.ForestryAPI;
import forestry.api.food.BeverageManager;
import forestry.api.food.IBeverageEffect;
import forestry.api.food.IInfuserManager;
import forestry.api.food.IIngredientManager;
import forestry.core.CreativeTabForestry;
import forestry.core.config.ForestryItem;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.food.BeverageEffect;
import forestry.food.items.ItemBeverage;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemInfuser
extends ItemForestry {
    public ItemInfuser(int i) {
        super(i);
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabForestry.tabForestry);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.InfuserGUI.ordinal(), world, (int)entityplayer.field_70165_t, (int)entityplayer.field_70163_u, (int)entityplayer.field_70161_v);
        }
        return itemstack;
    }

    public static void initialize() {
        BeverageManager.ingredientManager.addIngredient(new ItemStack(ForestryItem.pollen, 1, 0), "Strong Curative");
        BeverageManager.ingredientManager.addIngredient(new ItemStack(ForestryItem.pollen, 1, 1), "Weak Curative");
        BeverageManager.infuserManager.addMixture(1, new ItemStack(ForestryItem.pollen, 1, 0), BeverageEffect.strongAntidote);
        BeverageManager.infuserManager.addMixture(1, new ItemStack(ForestryItem.pollen, 1, 1), BeverageEffect.weakAntidote);
    }

    public static class InfuserInventory
    implements IInventory {
        private ItemStack[] inventoryStacks = new ItemStack[6];
        private short inputSlot = 0;
        private short outputSlot = 1;
        private short ingredientSlot1 = (short)2;
        EntityPlayer player;

        public InfuserInventory(EntityPlayer player) {
            this.player = player;
        }

        private void trySeasoning() {
            ItemStack[] toRemove;
            if (this.inventoryStacks[this.inputSlot] == null) {
                return;
            }
            if (this.inventoryStacks[this.outputSlot] != null) {
                return;
            }
            if (!this.inventoryStacks[this.inputSlot].func_77969_a(new ItemStack(ForestryItem.beverage, 1, 0))) {
                return;
            }
            ItemStack[] ingredients = new ItemStack[4];
            System.arraycopy(this.inventoryStacks, this.ingredientSlot1, ingredients, 0, 4);
            if (!BeverageManager.infuserManager.hasMixtures(ingredients)) {
                return;
            }
            ItemStack seasoned = BeverageManager.infuserManager.getSeasoned(this.inventoryStacks[this.inputSlot], ingredients);
            if (seasoned == null) {
                return;
            }
            block0: for (ItemStack templ : toRemove = BeverageManager.infuserManager.getRequired(ingredients)) {
                ItemStack ghost = templ.func_77946_l();
                for (int i = this.ingredientSlot1; i < this.func_70302_i_(); ++i) {
                    if (this.inventoryStacks[i] == null) continue;
                    if (ghost.field_77994_a <= 0) continue block0;
                    if ((ghost.func_77960_j() < 0 || !this.inventoryStacks[i].func_77969_a(ghost)) && (ghost.func_77960_j() >= 0 || ghost.field_77993_c != this.inventoryStacks[i].field_77993_c)) continue;
                    ItemStack removed = this.func_70298_a(i, 1);
                    ghost.field_77994_a -= removed.field_77994_a;
                }
            }
            this.func_70298_a(this.inputSlot, 1);
            this.inventoryStacks[this.outputSlot] = seasoned;
        }

        public ItemStack func_70298_a(int i, int j) {
            if (this.inventoryStacks[i] == null) {
                return null;
            }
            if (this.inventoryStacks[i].field_77994_a <= j) {
                ItemStack product = this.inventoryStacks[i];
                this.inventoryStacks[i] = null;
                return product;
            }
            ItemStack product = this.inventoryStacks[i].func_77979_a(j);
            if (this.inventoryStacks[i].field_77994_a == 0) {
                this.inventoryStacks[i] = null;
            }
            return product;
        }

        public void func_70296_d() {
            if (!Proxies.common.isSimulating(this.player.field_70170_p)) {
                return;
            }
            this.trySeasoning();
        }

        public void func_70299_a(int i, ItemStack itemstack) {
            this.inventoryStacks[i] = itemstack;
        }

        public ItemStack func_70301_a(int i) {
            return this.inventoryStacks[i];
        }

        public int func_70302_i_() {
            return this.inventoryStacks.length;
        }

        public String func_70303_b() {
            return "Infuser";
        }

        public int func_70297_j_() {
            return 64;
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public ItemStack func_70304_b(int slot) {
            if (this.inventoryStacks[slot] == null) {
                return null;
            }
            ItemStack toReturn = this.inventoryStacks[slot];
            this.inventoryStacks[slot] = null;
            return toReturn;
        }

        public boolean func_94042_c() {
            return true;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return true;
        }
    }

    public static class IngredientManager
    implements IIngredientManager {
        private ArrayList ingredients = new ArrayList();

        @Override
        public void addIngredient(ItemStack ingredient, String description) {
            this.ingredients.add(new Ingredient(ingredient, description));
        }

        @Override
        public String getDescription(ItemStack itemstack) {
            if (itemstack == null) {
                return null;
            }
            for (Ingredient ingredient : this.ingredients) {
                if (ingredient.ingredient.func_77960_j() < 0 && ingredient.ingredient.field_77993_c == itemstack.field_77993_c) {
                    return ingredient.description;
                }
                if (ingredient.ingredient.func_77960_j() < 0 || !ingredient.ingredient.func_77969_a(itemstack)) continue;
                return ingredient.description;
            }
            return null;
        }
    }

    public static class Ingredient {
        public final ItemStack ingredient;
        public final String description;

        public Ingredient(ItemStack ingredient, String description) {
            this.ingredient = ingredient;
            this.description = description;
        }
    }

    public static class MixtureManager
    implements IInfuserManager {
        private ArrayList mixtures = new ArrayList();

        @Override
        public void addMixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredient, effect));
        }

        @Override
        public void addMixture(int meta, ItemStack[] ingredients, IBeverageEffect effect) {
            this.mixtures.add(new Mixture(meta, ingredients, effect));
        }

        public boolean isIngredient(ItemStack itemstack) {
            for (Mixture ingredient : this.mixtures) {
                if (!ingredient.isIngredient(itemstack)) continue;
                return true;
            }
            return false;
        }

        private Mixture[] getMatchingMixtures(ItemStack[] ingredients) {
            ArrayList<Mixture> matches = new ArrayList<Mixture>();
            for (Mixture mixture : this.mixtures) {
                if (!mixture.matches(ingredients)) continue;
                matches.add(mixture);
            }
            return matches.toArray(new Mixture[0]);
        }

        @Override
        public boolean hasMixtures(ItemStack[] ingredients) {
            return this.getMatchingMixtures(ingredients).length > 0;
        }

        @Override
        public ItemStack[] getRequired(ItemStack[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            ArrayList<ItemStack> required = new ArrayList<ItemStack>();
            for (Mixture mixture : mixtures) {
                required.addAll(Arrays.asList(mixture.getIngredients()));
            }
            return required.toArray(new ItemStack[0]);
        }

        @Override
        public ItemStack getSeasoned(ItemStack base, ItemStack[] ingredients) {
            Mixture[] mixtures = this.getMatchingMixtures(ingredients);
            ArrayList<IBeverageEffect> effects = new ArrayList<IBeverageEffect>();
            effects.addAll(Arrays.asList(((ItemBeverage)base.func_77973_b()).beverages[base.func_77960_j()].loadEffects(base)));
            int weight = 0;
            int meta = 0;
            for (Mixture mixture : mixtures) {
                effects.add(mixture.getEffect());
                if (mixture.getWeight() <= weight) continue;
                weight = mixture.getWeight();
                meta = mixture.getMeta();
            }
            ItemStack seasoned = base.func_77946_l();
            seasoned.func_77964_b(meta);
            ((ItemBeverage)base.func_77973_b()).beverages[meta].saveEffects(seasoned, effects.toArray(new IBeverageEffect[0]));
            return seasoned;
        }
    }

    public static class Mixture {
        private int meta;
        private ItemStack[] ingredients;
        private IBeverageEffect effect;

        public Mixture(int meta, ItemStack ingredient, IBeverageEffect effect) {
            this(meta, new ItemStack[]{ingredient}, effect);
        }

        public Mixture(int meta, ItemStack[] ingredients, IBeverageEffect effect) {
            this.meta = meta;
            this.ingredients = ingredients;
            this.effect = effect;
        }

        public ItemStack[] getIngredients() {
            return this.ingredients;
        }

        public boolean isIngredient(ItemStack itemstack) {
            for (ItemStack ingredient : this.ingredients) {
                if (ingredient.func_77960_j() < 0 && ingredient.field_77993_c == itemstack.field_77993_c) {
                    return true;
                }
                if (ingredient.func_77960_j() < 0 || !ingredient.func_77969_a(itemstack)) continue;
                return true;
            }
            return false;
        }

        public boolean matches(ItemStack[] res) {
            if (res == null || res.length <= 0) {
                return false;
            }
            boolean matchedAll = true;
            for (ItemStack stack : this.ingredients) {
                boolean matched = false;
                for (ItemStack matchStack : res) {
                    if (matchStack == null) continue;
                    if (stack.func_77960_j() < 0 && stack.field_77993_c == matchStack.field_77993_c) {
                        if (stack.field_77994_a > matchStack.field_77994_a) continue;
                        matched = true;
                        break;
                    }
                    if (stack.func_77960_j() < 0 || !stack.func_77969_a(matchStack) || stack.field_77994_a > matchStack.field_77994_a) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                matchedAll = false;
            }
            return matchedAll;
        }

        public IBeverageEffect getEffect() {
            return this.effect;
        }

        public int getMeta() {
            return this.meta;
        }

        public int getWeight() {
            return this.ingredients.length;
        }
    }
}

