/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.gates.ITriggerParameter;
import forestry.api.core.ITileStructure;
import forestry.core.triggers.Trigger;
import forestry.farming.gadgets.TileFarmPlain;
import forestry.farming.gadgets.TileHatch;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerLowSoil
extends Trigger {
    private int threshold = 64;

    public TriggerLowSoil(int id, int threshold) {
        super(id, "lowSoil");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold;
    }

    @Override
    public boolean hasParameter() {
        return true;
    }

    @Override
    public boolean isTriggerActive(ForgeDirection direction, TileEntity tile, ITriggerParameter parameter) {
        ItemStack filter;
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        ITileStructure central = ((TileHatch)tile).getCentralTE();
        if (central == null || !(central instanceof TileFarmPlain)) {
            return false;
        }
        if (parameter == null || parameter.getItemStack() == null) {
            filter = new ItemStack(-1, this.threshold, -1);
        } else {
            filter = parameter.getItemStack().func_77946_l();
            filter.field_77994_a = this.threshold;
        }
        return !((TileFarmPlain)central).hasResources(new ItemStack[]{filter});
    }
}

