/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.utils.Vect;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class FarmLogic
implements IFarmLogic {
    World world;
    IFarmHousing housing;
    boolean isManual;

    public FarmLogic(IFarmHousing housing) {
        this.housing = housing;
    }

    public FarmLogic setManual(boolean flag) {
        this.isManual = flag;
        return this;
    }

    @Override
    public String getTextureSheet() {
        return "/gui/items.png";
    }

    protected final boolean isAirBlock(Vect position) {
        return this.world.func_72799_c(position.x, position.y, position.z);
    }

    protected final boolean isWaterBlock(Vect position) {
        return this.world.func_72798_a(position.x, position.y, position.z) == Block.field_71943_B.field_71990_ca;
    }

    protected final boolean isWoodBlock(Vect position) {
        int blockid = this.getBlockId(position);
        return Block.field_71973_m[blockid] != null && Block.field_71973_m[blockid].isWood(this.world, position.x, position.y, position.z);
    }

    protected final int getBlockId(Vect position) {
        return this.world.func_72798_a(position.x, position.y, position.z);
    }

    protected final int getBlockMeta(Vect position) {
        return this.world.func_72805_g(position.x, position.y, position.z);
    }

    protected final ItemStack getAsItemStack(Vect position) {
        return new ItemStack(this.getBlockId(position), 1, this.getBlockMeta(position));
    }

    protected final Vect translateWithOffset(int x, int y, int z, ForgeDirection direction, int step) {
        return new Vect(x + direction.offsetX * step, y + direction.offsetY * step, z + direction.offsetZ * step);
    }

    protected final void setBlock(Vect position, int id, int meta) {
        this.world.func_72832_d(position.x, position.y, position.z, id, meta, 2);
    }
}

