/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.proxy.Proxies;
import forestry.core.utils.Vect;
import forestry.farming.logic.Crop;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class CropBlock
extends Crop {
    int blockId;
    int meta;

    public CropBlock(World world, int blockId, int meta, Vect position) {
        super(world, position);
        this.blockId = blockId;
        this.meta = meta;
    }

    @Override
    protected boolean isCrop(Vect pos) {
        return this.getBlockId(pos) == this.blockId && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection harvestBlock(Vect pos) {
        ArrayList harvested = Block.field_71973_m[this.blockId].getBlockDropped(this.world, pos.x, pos.y, pos.z, this.meta, 0);
        Proxies.common.addBlockDestroyEffects(this.world, pos.x, pos.y, pos.z, this.blockId, 0);
        this.world.func_72832_d(pos.x, pos.y, pos.z, 0, 0, 2);
        return harvested;
    }

    public String toString() {
        return String.format("CropBlock [ position: [ %s ]; blockId: %s; meta: %s ]", this.position.toString(), this.blockId, this.meta);
    }
}

