/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gadgets;

import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.utils.TankSlot;
import forestry.farming.gadgets.TileFarm;
import forestry.farming.gadgets.TileFarmPlain;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class TileValve
extends TileFarm
implements ILiquidTankContainer {
    public TileValve() {
        this.fixedType = 6;
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    protected void createInventory() {
    }

    private TankSlot getMasterTank() {
        if (!this.isIntegratedIntoStructure() || !this.hasMaster()) {
            return null;
        }
        TileFarmPlain central = (TileFarmPlain)this.getCentralTE();
        if (central == null) {
            return null;
        }
        return central.getTank();
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        TankSlot tank = this.getMasterTank();
        if (tank == null) {
            return 0;
        }
        return tank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        TankSlot tank = this.getMasterTank();
        if (tank == null) {
            return null;
        }
        return tank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        TankSlot tank = this.getMasterTank();
        if (tank == null) {
            return TankSlot.FAKETANK_ARRAY;
        }
        return new ILiquidTank[]{tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankSlot tank = this.getMasterTank();
        if (tank == null) {
            return TankSlot.FAKETANK;
        }
        return tank;
    }
}

