/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gui;

import forestry.core.gui.ContainerForestry;
import forestry.core.gui.LiquidTankSlot;
import forestry.core.gui.Widget;
import forestry.core.gui.WidgetManager;
import forestry.core.utils.StringUtil;
import forestry.energy.gadgets.EngineBronze;
import forestry.energy.gui.ContainerEngineBronze;
import forestry.energy.gui.GuiEngine;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import org.lwjgl.opengl.GL11;

public class GuiEngineBronze
extends GuiEngine {
    public GuiEngineBronze(InventoryPlayer inventory, EngineBronze tile) {
        super("/gfx/forestry/gui/bioengine.png", (ContainerForestry)new ContainerEngineBronze(inventory, tile), tile);
        this.widgetManager.add(new LiquidTankSlot(this.widgetManager, 89, 19, tile, 0));
        this.widgetManager.add(new LiquidTankSlot(this.widgetManager, 107, 19, tile, 1));
        this.widgetManager.add(new BiogasSlot(this.widgetManager, 30, 47, tile));
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        super.drawGuiContainerForegroundLayer();
        String name = StringUtil.localize("tile.for.engine.2");
        this.field_73886_k.func_78276_b(name, this.getCenteredOffset(name), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int i, int j) {
        this.drawBackground();
        EngineBronze engine = (EngineBronze)this.tile;
        int temp = engine.getOperatingTemperatureScaled(16);
        if (temp > 16) {
            temp = 16;
        }
        if (temp > 0) {
            this.func_73729_b(this.guiLeft + 53, this.guiTop + 47 + 16 - temp, 176, 76 - temp, 4, temp);
        }
    }

    protected class BiogasSlot
    extends Widget {
        EngineBronze engine;

        public BiogasSlot(WidgetManager manager, int xPos, int yPos, EngineBronze engine) {
            super(manager, xPos, yPos);
            this.engine = engine;
            this.height = 16;
        }

        @Override
        public void draw(int startX, int startY) {
            int x;
            if (this.engine == null || this.engine.totalTime <= 0) {
                return;
            }
            Icon liquidIcon = null;
            int squaled = this.engine.burnTime * this.height / this.engine.totalTime;
            if (squaled > this.height) {
                squaled = this.height;
            }
            String texture = "/terrain.png";
            if (this.engine.currentLiquidId <= 0) {
                return;
            }
            int liquidId = this.engine.currentLiquidId;
            int liquidMeta = this.engine.currentLiquidMeta;
            if (liquidId < Block.field_71973_m.length && Block.field_71973_m[liquidId].field_71990_ca > 0) {
                liquidIcon = Block.field_71973_m[liquidId].func_71851_a(0);
            } else {
                liquidIcon = Item.field_77698_e[liquidId].func_77617_a(liquidMeta);
                texture = "/gui/items.png";
            }
            this.manager.minecraft.field_71446_o.func_98187_b(texture);
            int start = 0;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            do {
                x = 0;
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos + this.height - x - start, liquidIcon, 16, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
            ((GuiEngineBronze)GuiEngineBronze.this).field_73882_e.field_71446_o.func_98187_b(GuiEngineBronze.this.textureFile);
        }

        @Override
        public String getTooltip(EntityPlayer player) {
            if (this.engine.currentLiquidId <= 0) {
                return StringUtil.localize("gui.empty");
            }
            String tooltip = Item.field_77698_e[this.engine.currentLiquidId].func_77628_j(new ItemStack(this.engine.currentLiquidId, 1, this.engine.currentLiquidMeta));
            return tooltip;
        }
    }
}

