/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.TemperatureState;
import forestry.core.config.Config;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.GuiId;
import forestry.core.utils.DelayTimer;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.InventoryAdapter;
import forestry.plugins.PluginIC2;
import ic2.api.Direction;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EngineTin
extends Engine
implements ISocketable,
IInventory,
IEnergySink {
    private short batterySlot = 0;
    private InventoryAdapter inventory = new InventoryAdapter(1, "electrical");
    private InventoryAdapter sockets = new InventoryAdapter(1, "sockets");
    private boolean isAddedToEnergyNet = false;
    private int euStored = 0;
    private EuConfig euConfig = new EuConfig(6, 2, 12);
    private DelayTimer delayUpdateTimer = new DelayTimer();

    public EngineTin() {
        super(3000, 10000, 400);
        this.setHints((String[])Config.hints.get("engine.tin"));
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.EngineTinGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        ICircuitBoard chipset;
        super.func_70307_a(nbttagcompound);
        this.euStored = nbttagcompound.func_74762_e("EngineEnergyStored");
        this.inventory.readFromNBT(nbttagcompound);
        this.sockets.readFromNBT(nbttagcompound);
        ItemStack chip = this.sockets.func_70301_a(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("EngineEnergyStored", this.euStored);
        this.inventory.writeToNBT(nbttagcompound);
        this.sockets.writeToNBT(nbttagcompound);
    }

    @Override
    public int dissipateHeat() {
        TemperatureState tempState;
        if (this.heat <= 0) {
            return 0;
        }
        int loss = 0;
        if (!this.isBurning() || !this.isActivated()) {
            ++loss;
        }
        if ((tempState = this.getTemperatureState()) == TemperatureState.OVERHEATING || tempState == TemperatureState.OPERATING_TEMPERATURE) {
            ++loss;
        }
        this.heat -= loss;
        return loss;
    }

    @Override
    public int generateHeat() {
        int gain = 0;
        if (this.isActivated() && this.isBurning()) {
            ++gain;
            if ((double)this.storedEnergy / (double)this.maxEnergy > 0.5) {
                ++gain;
            }
        }
        this.addHeat(gain);
        return gain;
    }

    @Override
    public void updateServerSide() {
        if (!PluginIC2.instance.isAvailable()) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        if (!this.isAddedToEnergyNet) {
            EnergyNet.getForWorld(this.field_70331_k).addTileEntity(this);
            this.isAddedToEnergyNet = true;
        }
        super.updateServerSide();
        if (this.forceCooldown) {
            this.setErrorState(EnumErrorCode.FORCEDCOOLDOWN);
            return;
        }
        if (this.inventory.func_70301_a(this.batterySlot) != null) {
            this.replenishFromBattery(this.batterySlot);
        }
        if (!this.delayUpdateTimer.delayPassed(this.field_70331_k, 80L)) {
            return;
        }
        if (this.currentOutput <= 0 && this.getErrorState() == EnumErrorCode.OK) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public void burn() {
        this.currentOutput = 0;
        if (!this.isActivated()) {
            return;
        }
        if (this.euStored >= this.euConfig.euForCycle) {
            this.currentOutput = this.euConfig.mjPerCycle;
            this.addEnergy(this.euConfig.mjPerCycle);
            this.euStored -= this.euConfig.euForCycle;
        }
    }

    private void replenishFromBattery(int slot) {
        if (this.euStored >= this.euConfig.euStorage) {
            return;
        }
        if (!this.isActivated()) {
            return;
        }
        ItemStack itemstack = this.inventory.func_70301_a(slot);
        if (itemstack == null) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof IElectricItem) || !((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack)) {
            return;
        }
        int space = this.euConfig.euStorage - this.euStored;
        if (space >= this.euConfig.euForCycle * 3) {
            space = this.euConfig.euForCycle * 3;
        }
        this.euStored += ElectricItem.discharge(itemstack, space, Integer.MAX_VALUE, true, false);
    }

    @Override
    public boolean isBurning() {
        return this.mayBurn() && this.euStored >= this.euConfig.euForCycle;
    }

    public int getStorageScaled(int i) {
        return this.euStored * i / (this.euConfig.euStorage + this.euConfig.euMaxAccept - 1);
    }

    public EnumTankLevel rateLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.currentOutput = j;
                break;
            }
            case 1: {
                this.storedEnergy = j;
                break;
            }
            case 2: {
                this.heat = j;
                break;
            }
            case 3: {
                this.euStored = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
        iCrafting.func_71112_a(containerEngine, 0, this.currentOutput);
        iCrafting.func_71112_a(containerEngine, 1, (int)this.storedEnergy);
        iCrafting.func_71112_a(containerEngine, 2, this.heat);
        iCrafting.func_71112_a(containerEngine, 3, this.euStored);
    }

    public void changeEnergyConfig(int euChange, int mjChange, int storageChange) {
        this.euConfig.euForCycle += euChange;
        this.euConfig.mjPerCycle += mjChange;
        this.euConfig.euStorage += storageChange;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.isAddedToEnergyNet;
    }

    @Override
    public int demandsEnergy() {
        return this.euConfig.euStorage - this.euStored;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        int input = Math.min(this.euConfig.euStorage + this.euConfig.euMaxAccept - 1 - this.euStored, amount);
        this.euStored += input;
        return amount - input;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int getSocketCount() {
        return this.sockets.func_70302_i_();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.func_70301_a(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.func_70301_a(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.func_70301_a(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.func_70301_a(slot))) != null) {
            chipset.onRemoval(this);
        }
        if (stack == null) {
            this.sockets.func_70299_a(slot, stack);
            return;
        }
        this.sockets.func_70299_a(slot, stack);
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    protected static class EuConfig {
        public int euForCycle;
        public int mjPerCycle;
        public int euStorage;
        public int euMaxAccept = 512;

        public EuConfig(int euForCycle, int mjPerCycle, int euStorage) {
            this.euForCycle = euForCycle;
            this.mjPerCycle = mjPerCycle;
            this.euStorage = euStorage;
        }
    }
}

