/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import forestry.core.TemperatureState;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.TileBase;
import forestry.core.utils.DamageSourceForestry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;

public class EngineClockwork
extends Engine {
    private static final float WIND_EXHAUSTION = 0.05f;
    private static final float WIND_TENSION_BASE = 0.5f;
    private static final int WIND_DELAY = 10;
    private static final int ENGINE_CLOCKWORK_HEAT_MAX = 300000;
    private static final float ENGINE_CLOCKWORK_ENERGY_PER_CYCLE = 0.25f;
    private static final float ENGINE_CLOCKWORK_WIND_MAX = 8.0f;
    private static final DamageSourceForestry damageSourceEngineClockwork = new DamageSourceForestry("engine.clockwork");
    private float tension = 0.0f;
    private short delay = 0;

    public EngineClockwork() {
        super(300000, 1000, 50);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        if (this.tension <= 0.0f) {
            this.tension = 0.5f;
        } else if (this.tension < 8.5f) {
            this.tension += (8.5f - this.tension) / 8.5f * 0.5f;
        } else {
            return;
        }
        player.func_71020_j(0.05f);
        if ((double)this.tension > 8.05) {
            player.func_70097_a((DamageSource)damageSourceEngineClockwork, 6);
        }
        this.tension = this.tension > 8.5f ? 8.5f : this.tension;
        this.delay = (short)10;
        this.sendNetworkUpdate();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.tension = nbttagcompound.func_74760_g("Wound");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74776_a("Wound", this.tension);
    }

    @Override
    public boolean isActivated() {
        return true;
    }

    @Override
    public int dissipateHeat() {
        return 0;
    }

    @Override
    public int generateHeat() {
        return 0;
    }

    @Override
    public boolean mayBurn() {
        return true;
    }

    @Override
    public void burn() {
        this.heat = (int)(this.tension * 10000.0f);
        if (this.delay > 0) {
            this.delay = (short)(this.delay - 1);
            return;
        }
        if (!this.isBurning()) {
            return;
        }
        this.tension = this.tension > 0.01f ? (this.tension *= 0.9995f) : 0.0f;
        this.addEnergy(0.25f * this.tension);
    }

    @Override
    public boolean isBurning() {
        return this.tension > 0.0f;
    }

    @Override
    public TemperatureState getTemperatureState() {
        double scaled = (float)(this.heat / 10000) / 8.0f;
        if (scaled < 0.2) {
            return TemperatureState.COOL;
        }
        if (scaled < 0.45) {
            return TemperatureState.WARMED_UP;
        }
        if (scaled < 0.65) {
            return TemperatureState.OPERATING_TEMPERATURE;
        }
        if (scaled < 0.85) {
            return TemperatureState.RUNNING_HOT;
        }
        return TemperatureState.OVERHEATING;
    }

    @Override
    public float getPistonSpeed() {
        if (this.delay > 0) {
            return 0.0f;
        }
        float fromClockwork = this.tension / 8.0f * 0.08f;
        return fromClockwork >= 0.01f ? fromClockwork : (this.storedEnergy > 0.0f ? 0.01f : 0.0f);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
    }

    @Override
    public void sendGUINetworkData(Container containerEngine, ICrafting iCrafting) {
    }
}

