/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidHelper {
    private static HashMap myLiquids = new HashMap();

    public static boolean isEmptyLiquidData() {
        return LiquidContainerRegistry.getRegisteredLiquidContainerData().length <= 0;
    }

    public static boolean isEmptyContainer(ItemStack empty) {
        return LiquidContainerRegistry.isEmptyContainer((ItemStack)empty);
    }

    public static LiquidContainerData getEmptyContainer(ItemStack empty, LiquidStack liquid) {
        for (LiquidContainerData cont : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (!cont.stillLiquid.isLiquidEqual(liquid) || !cont.container.func_77969_a(empty)) continue;
            return cont;
        }
        return null;
    }

    public static LiquidContainerData getLiquidContainer(ItemStack container) {
        for (LiquidContainerData cont : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (!cont.filled.func_77969_a(container)) continue;
            return cont;
        }
        return null;
    }

    public static LiquidContainerData createLiquidData(String ident, LiquidStack stillLiquid, ItemStack filled, ItemStack container) {
        return new LiquidContainerData(LiquidHelper.getOrCreateLiquid(ident, stillLiquid), filled, container);
    }

    public static LiquidStack getOrCreateLiquid(String ident, LiquidStack stillLiquid) {
        LiquidStack dict = LiquidDictionary.getOrCreateLiquid((String)ident, (LiquidStack)stillLiquid);
        if (dict.itemID == stillLiquid.itemID) {
            myLiquids.put(ident, dict);
        }
        return dict;
    }

    public static LiquidStack getLiquid(String name, int amount) {
        return LiquidDictionary.getLiquid((String)name, (int)amount);
    }

    public static void injectLiquidContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, null, 0);
    }

    public static void injectWaxContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, new ItemStack(ForestryItem.beeswax), 10);
    }

    public static void injectRefractoryContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, new ItemStack(ForestryItem.refractoryWax), 10);
    }

    public static void injectTinContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, ForestryItem.ingotTin, 5);
    }

    public static void injectLiquidContainer(String name, int volume, ItemStack filled, ItemStack empty, ItemStack remnant, int chance) {
        LiquidStack contained = LiquidHelper.getLiquid(name, volume);
        if (contained == null) {
            throw new IllegalArgumentException(String.format("Attempted to inject a liquid container for the non-existent liquid '%s'.", name));
        }
        LiquidContainerData container = new LiquidContainerData(contained, filled, empty);
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)container);
        if (RecipeManagers.squeezerManager != null && !container.container.func_77973_b().func_77634_r()) {
            if (remnant != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filled}, container.stillLiquid, remnant, chance);
            } else {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filled}, container.stillLiquid);
            }
        }
    }

    public static void resetLiquidIcons() {
        for (Map.Entry entry : myLiquids.entrySet()) {
            Proxies.log.finest("Setting icon for liquid '%s' (%s:%s).", entry.getKey(), ((LiquidStack)entry.getValue()).itemID, ((LiquidStack)entry.getValue()).itemMeta);
            LiquidStack canonical = LiquidDictionary.getCanonicalLiquid((String)((String)entry.getKey()));
            if (canonical == null) continue;
            Proxies.log.finest("Setting icon for canonical liquid '%s' (%s:%s).", entry.getKey(), canonical.itemID, canonical.itemMeta);
            if (canonical.itemID < Block.field_71973_m.length && Block.field_71973_m[canonical.itemID] != null && Block.field_71973_m[canonical.itemID].field_71990_ca > 0) {
                canonical.setRenderingIcon(Block.field_71973_m[canonical.itemID].func_71858_a(0, canonical.itemMeta));
                canonical.setTextureSheet("/terrain.png");
                continue;
            }
            if (canonical.itemID <= 0 || Item.field_77698_e[canonical.itemID] == null) continue;
            canonical.setRenderingIcon(Item.field_77698_e[canonical.itemID].func_77617_a(canonical.itemMeta));
            canonical.setTextureSheet("/gui/items.png");
        }
    }
}

