/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class IDAllocator
extends WorldSavedData {
    public static String SAVE_NAME = "IDAlloc";
    public static IDAllocator cachedIDAllocator;
    private int maxId = 2048;
    public HashMap idMap = new HashMap();

    public static IDAllocator getIDAllocator(World world, String type) {
        if (cachedIDAllocator != null) {
            return cachedIDAllocator;
        }
        IDAllocator allocator = (IDAllocator)world.func_72943_a(IDAllocator.class, SAVE_NAME + "." + type);
        if (allocator == null) {
            allocator = new IDAllocator(SAVE_NAME + "." + type);
            world.func_72823_a(SAVE_NAME + type, (WorldSavedData)allocator);
        }
        cachedIDAllocator = allocator;
        return allocator;
    }

    public IDAllocator(String par1Str) {
        super(par1Str);
    }

    public int getId(String uid) {
        if (this.idMap.containsKey(uid)) {
            return (Integer)this.idMap.get(uid);
        }
        for (int i = 0; i < this.maxId; ++i) {
            if (this.idMap.containsValue(i)) continue;
            this.idMap.put(uid, i);
            this.func_76185_a();
            return i;
        }
        throw new RuntimeException("No ids left for the type: " + uid);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("IdMap");
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound subcompound = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.idMap.put(subcompound.func_74779_i("UID"), subcompound.func_74762_e("Id"));
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (Map.Entry entry : this.idMap.entrySet()) {
            NBTTagCompound subcompound = new NBTTagCompound();
            subcompound.func_74778_a("UID", (String)entry.getKey());
            subcompound.func_74768_a("Id", ((Integer)entry.getValue()).intValue());
            nbttaglist.func_74742_a((NBTBase)subcompound);
        }
        nbttagcompound.func_74782_a("IdMap", (NBTBase)nbttaglist);
    }
}

